/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.core.BytecodeArrayTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeMethodTypeConstant;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeStringConstant;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;

public class BytecodeInstructionGenericLDC
extends BytecodeInstruction {
    private final int constantIndex;
    private final BytecodeConstantPool constantPool;

    public BytecodeInstructionGenericLDC(BytecodeOpcodeAddress aOpcodeIndex, int aConstantIndex, BytecodeConstantPool aConstantPool) {
        super(aOpcodeIndex);
        this.constantIndex = aConstantIndex;
        this.constantPool = aConstantPool;
    }

    public BytecodeConstant constant() {
        return this.constantPool.constantByIndex(this.constantIndex - 1);
    }

    @Override
    public void performLinking(BytecodeClass aOwningClass, BytecodeLinkerContext aLinkerContext) {
        BytecodeConstant theConstant = this.constant();
        if (theConstant instanceof BytecodeStringConstant) {
            aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromRuntimeClass(Array.class));
            BytecodeObjectTypeRef theObjectTypeRef = BytecodeObjectTypeRef.fromRuntimeClass(String.class);
            aLinkerContext.resolveClass(theObjectTypeRef).resolveConstructorInvocation(new BytecodeMethodSignature(BytecodePrimitiveTypeRef.VOID, new BytecodeTypeRef[]{new BytecodeArrayTypeRef(BytecodePrimitiveTypeRef.BYTE, 1)}));
        }
        if (theConstant instanceof BytecodeClassinfoConstant) {
            BytecodeClassinfoConstant theClassInfo = (BytecodeClassinfoConstant)theConstant;
            if (theClassInfo.getConstant().stringValue().startsWith("[")) {
                BytecodeTypeRef theType = aLinkerContext.getSignatureParser().toFieldType(theClassInfo.getConstant());
                aLinkerContext.resolveTypeRef(theType);
            } else {
                aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theClassInfo.getConstant()));
            }
        }
        if (theConstant instanceof BytecodeMethodTypeConstant) {
            BytecodeMethodTypeConstant m = (BytecodeMethodTypeConstant)theConstant;
            BytecodeMethodSignature theSignature = m.getDescriptorIndex().methodSignature();
            aLinkerContext.resolveTypeRef(theSignature.getReturnType());
            for (BytecodeTypeRef ref : theSignature.getArguments()) {
                aLinkerContext.resolveTypeRef(ref);
            }
        }
    }
}

