/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeFieldRefConstant;
import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeNameIndex;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;

public class BytecodeInstructionGETSTATIC
extends BytecodeInstruction {
    private final int index;
    private final BytecodeConstantPool constantPool;

    public BytecodeInstructionGETSTATIC(BytecodeOpcodeAddress aIndex, int aConstantPoolIndex, BytecodeConstantPool aConstantPool) {
        super(aIndex);
        this.index = aConstantPoolIndex;
        this.constantPool = aConstantPool;
    }

    public BytecodeFieldRefConstant getConstant() {
        return (BytecodeFieldRefConstant)this.constantPool.constantByIndex(this.index - 1);
    }

    @Override
    public void performLinking(BytecodeClass aOwningClass, BytecodeLinkerContext aLinkerContext) {
        BytecodeFieldRefConstant theConstant = this.getConstant();
        BytecodeClassinfoConstant theClass = theConstant.getClassIndex().getClassConstant();
        BytecodeNameIndex theName = theConstant.getNameAndTypeIndex().getNameAndType().getNameIndex();
        BytecodeLinkedClass theLinkedClass = aLinkerContext.resolveClass(BytecodeObjectTypeRef.fromUtf8Constant(theClass.getConstant()));
        if (!theLinkedClass.resolveStaticField(theName.getName())) {
            throw new IllegalStateException("Cannot link static field " + theName.getName().stringValue() + " in " + theLinkedClass.getClassName().name());
        }
    }
}

