/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.classlib.Array;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeSignatureParser;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;

public class BytecodeInstructionANEWARRAY
extends BytecodeInstruction {
    private final int typeIndex;
    private final BytecodeConstantPool constantPool;

    public BytecodeInstructionANEWARRAY(BytecodeOpcodeAddress aIndex, int aTypeIndex, BytecodeConstantPool aConstantPool) {
        super(aIndex);
        this.typeIndex = aTypeIndex;
        this.constantPool = aConstantPool;
    }

    public BytecodeObjectTypeRef getObjectType() {
        return BytecodeObjectTypeRef.fromRuntimeClass(Array.class);
    }

    public BytecodeTypeRef getArrayType(BytecodeSignatureParser aSignatureParser) {
        BytecodeClassinfoConstant theClassInfo = this.getTypeConstant();
        String theType = theClassInfo.getConstant().stringValue();
        if (theType.startsWith("[")) {
            return aSignatureParser.toFieldType(theClassInfo.getConstant());
        }
        return BytecodeObjectTypeRef.fromUtf8Constant(theClassInfo.getConstant());
    }

    private BytecodeClassinfoConstant getTypeConstant() {
        return (BytecodeClassinfoConstant)this.constantPool.constantByIndex(this.typeIndex - 1);
    }

    @Override
    public void performLinking(BytecodeClass aOwningClass, BytecodeLinkerContext aLinkerContext) {
        aLinkerContext.resolveClass(this.getObjectType());
        aLinkerContext.resolveTypeRef(this.getArrayType(aLinkerContext.getSignatureParser()));
    }
}

