/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;

public class BytecodeExceptionTableEntry {
    private final BytecodeOpcodeAddress startPC;
    private final BytecodeOpcodeAddress endPc;
    private final BytecodeOpcodeAddress handlerPc;
    private final int catchType;
    private final BytecodeConstantPool constantPool;

    public BytecodeExceptionTableEntry(BytecodeOpcodeAddress aStartPC, BytecodeOpcodeAddress aEndPc, BytecodeOpcodeAddress aHandlerPc, int aCatchType, BytecodeConstantPool aConstantPool) {
        this.startPC = aStartPC;
        this.endPc = aEndPc;
        this.handlerPc = aHandlerPc;
        this.catchType = aCatchType;
        this.constantPool = aConstantPool;
    }

    public BytecodeOpcodeAddress getStartPC() {
        return this.startPC;
    }

    public BytecodeOpcodeAddress getEndPc() {
        return this.endPc;
    }

    public BytecodeOpcodeAddress getHandlerPc() {
        return this.handlerPc;
    }

    public boolean isFinally() {
        return this.catchType == 0;
    }

    public int getCatchTypeAsInt() {
        return this.catchType;
    }

    public BytecodeClassinfoConstant getCatchType() {
        return (BytecodeClassinfoConstant)this.constantPool.constantByIndex(this.catchType - 1);
    }

    public boolean coveres(BytecodeOpcodeAddress aAddress) {
        return this.startPC.getAddress() <= aAddress.getAddress() && this.endPc.getAddress() > aAddress.getAddress();
    }
}

