/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeSignatureParser;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;

public class BytecodeDescriptorIndex {
    private final int index;
    private final BytecodeConstantPool constantPool;
    private final BytecodeSignatureParser signatureParser;
    private BytecodeMethodSignature signature;
    private BytecodeTypeRef typeRef;

    public BytecodeDescriptorIndex(int aIndex, BytecodeConstantPool aConstantPool, BytecodeSignatureParser aSignatureParser) {
        this.index = aIndex;
        this.constantPool = aConstantPool;
        this.signatureParser = aSignatureParser;
    }

    public BytecodeMethodSignature methodSignature() {
        if (this.signature == null) {
            this.signature = this.signatureParser.toMethodSignature((BytecodeUtf8Constant)this.constantPool.constantByIndex(this.index - 1));
        }
        return this.signature;
    }

    public BytecodeTypeRef fieldType() {
        if (this.typeRef == null) {
            this.typeRef = this.signatureParser.toFieldType((BytecodeUtf8Constant)this.constantPool.constantByIndex(this.index - 1));
        }
        return this.typeRef;
    }
}

