/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeLinkedClass;
import de.mirkosertic.bytecoder.core.BytecodeLinkerContext;
import de.mirkosertic.bytecoder.core.BytecodeObjectTypeRef;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class BytecodeClassTopologicOrder {
    private static final BytecodeObjectTypeRef OBJECT = BytecodeObjectTypeRef.fromRuntimeClass(Object.class);
    private final List<BytecodeLinkedClass> knownClasses = new ArrayList<BytecodeLinkedClass>();

    public BytecodeClassTopologicOrder(BytecodeLinkerContext linkerContext) {
        linkerContext.linkedClasses().forEach(t -> this.knownClasses.add((BytecodeLinkedClass)t.targetNode()));
        this.knownClasses.sort(Comparator.comparingInt(this::topo).thenComparing(o -> o.getClassName().name()));
    }

    private int topo(BytecodeLinkedClass aClass) {
        if (aClass.getClassName().equals(OBJECT)) {
            return 1;
        }
        int theTopo = this.topo(aClass.getSuperClass());
        for (BytecodeLinkedClass theImplementingType : aClass.getImplementingTypes(false, false)) {
            theTopo = Math.max(theTopo, this.topo(theImplementingType));
        }
        return theTopo + 1;
    }

    public List<BytecodeLinkedClass> getClassesInOrder() {
        return this.knownClasses;
    }
}

