/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.api.OverrideParentClass;
import de.mirkosertic.bytecoder.api.Substitutes;
import de.mirkosertic.bytecoder.core.BytecodeAccessFlags;
import de.mirkosertic.bytecoder.core.BytecodeAnnotation;
import de.mirkosertic.bytecoder.core.BytecodeAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeAttributes;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeField;
import de.mirkosertic.bytecoder.core.BytecodeInterface;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodSignature;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import java.util.Objects;

public class BytecodeClass {
    private final BytecodeConstantPool constantPool;
    private final BytecodeAccessFlags accessFlags;
    private final BytecodeClassinfoConstant thisClass;
    private final BytecodeClassinfoConstant superClass;
    private final BytecodeInterface[] interfaces;
    private final BytecodeField[] fields;
    private final BytecodeMethod[] methods;
    private final BytecodeAttributeInfo[] classAttributes;

    public BytecodeClass(BytecodeConstantPool aConstantPool, BytecodeAccessFlags aAccessFlags, BytecodeClassinfoConstant aThisClass, BytecodeClassinfoConstant aSuperClass, BytecodeInterface[] aInterfaces, BytecodeField[] aFields, BytecodeMethod[] aMethods, BytecodeAttributeInfo[] aClassAttributes) {
        this.constantPool = aConstantPool;
        this.accessFlags = aAccessFlags;
        this.thisClass = aThisClass;
        this.superClass = aSuperClass;
        this.interfaces = aInterfaces;
        this.fields = aFields;
        this.methods = aMethods;
        this.classAttributes = aClassAttributes;
    }

    public BytecodeClassinfoConstant getThisInfo() {
        return this.thisClass;
    }

    public BytecodeAccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    public BytecodeAttributes getAttributes() {
        return new BytecodeAttributes(this.classAttributes);
    }

    public BytecodeAttributeInfo[] getAttributesRaw() {
        return this.classAttributes;
    }

    public BytecodeConstantPool getConstantPool() {
        return this.constantPool;
    }

    public BytecodeField[] fields() {
        return this.fields;
    }

    public BytecodeField fieldByName(String aName) {
        for (BytecodeField theField : this.fields) {
            if (!Objects.equals(theField.getName().stringValue(), aName)) continue;
            return theField;
        }
        return null;
    }

    public BytecodeMethod methodByNameAndSignatureOrNull(String aMethodName, BytecodeMethodSignature aSignature) {
        for (BytecodeMethod theMethod : this.methods) {
            String theMethodName = theMethod.getName().stringValue();
            BytecodeAnnotation theAnnotation = theMethod.getAttributes().getAnnotationByType(Substitutes.class.getName());
            if (theAnnotation != null) {
                theMethodName = theAnnotation.getElementValueByName("value").stringValue();
            }
            if (!Objects.equals(aMethodName, theMethodName) || !theMethod.getSignature().matchesExactlyTo(aSignature)) continue;
            return theMethod;
        }
        return null;
    }

    public BytecodeClassinfoConstant getSuperClass() {
        BytecodeAnnotation theDelegatesTo = this.getAttributes().getAnnotationByType(OverrideParentClass.class.getName());
        if (theDelegatesTo != null) {
            final BytecodeAnnotation.ElementValue theParentOverride = theDelegatesTo.getElementValueByName("parentClass");
            return new BytecodeClassinfoConstant(-1, null, null){

                @Override
                public BytecodeUtf8Constant getConstant() {
                    return new BytecodeUtf8Constant(theParentOverride.stringValue().replace(".", "/"));
                }
            };
        }
        return this.superClass;
    }

    public BytecodeMethod[] getMethods() {
        return this.methods;
    }

    public BytecodeInterface[] getInterfaces() {
        return this.interfaces;
    }

    public BytecodeMethod classInitializerOrNull() {
        for (BytecodeMethod theMethod : this.methods) {
            if (!"<clinit>".equalsIgnoreCase(theMethod.getName().stringValue())) continue;
            return theMethod;
        }
        return null;
    }
}

