/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeInstruction;
import de.mirkosertic.bytecoder.core.BytecodeInstructionATHROW;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGOTO;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericRETURN;
import de.mirkosertic.bytecoder.core.BytecodeInstructionObjectRETURN;
import de.mirkosertic.bytecoder.core.BytecodeInstructionRETURN;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BytecodeBasicBlock {
    private final List<BytecodeInstruction> instructions = new ArrayList<BytecodeInstruction>();
    private final List<BytecodeBasicBlock> successors = new ArrayList<BytecodeBasicBlock>();
    private final Type type;
    private final Set<BytecodeUtf8Constant> catchType;

    public BytecodeBasicBlock(Type aType) {
        this.type = aType;
        this.catchType = null;
    }

    public BytecodeBasicBlock(Set<BytecodeUtf8Constant> aCatchType) {
        this.type = Type.EXCEPTION_HANDLER;
        this.catchType = aCatchType;
    }

    public Set<BytecodeUtf8Constant> getCatchType() {
        return this.catchType;
    }

    public void addSuccessor(BytecodeBasicBlock aBasicBlock) {
        this.successors.add(aBasicBlock);
    }

    public List<BytecodeBasicBlock> getSuccessors() {
        return this.successors;
    }

    public Type getType() {
        return this.type;
    }

    public BytecodeOpcodeAddress getStartAddress() {
        return this.instructions.get(0).getOpcodeAddress();
    }

    public void addInstruction(BytecodeInstruction aInstruction) {
        this.instructions.add(aInstruction);
    }

    public List<BytecodeInstruction> getInstructions() {
        return this.instructions;
    }

    public boolean endsWithReturn() {
        BytecodeInstruction theLastInstruction = this.instructions.get(this.instructions.size() - 1);
        return theLastInstruction instanceof BytecodeInstructionRETURN || theLastInstruction instanceof BytecodeInstructionGenericRETURN || theLastInstruction instanceof BytecodeInstructionObjectRETURN;
    }

    public boolean endsWithGoto() {
        BytecodeInstruction theLastInstruction = this.instructions.get(this.instructions.size() - 1);
        return theLastInstruction instanceof BytecodeInstructionGOTO;
    }

    public boolean endsWithThrow() {
        BytecodeInstruction theLastInstruction = this.instructions.get(this.instructions.size() - 1);
        return theLastInstruction instanceof BytecodeInstructionATHROW;
    }

    public BytecodeInstruction lastInstruction() {
        return this.instructions.get(this.instructions.size() - 1);
    }

    public static enum Type {
        NORMAL,
        EXCEPTION_HANDLER,
        FINALLY;

    }
}

