/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeAnnotation;
import de.mirkosertic.bytecoder.core.BytecodeAnnotationAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeAttributeInfo;
import java.util.Arrays;
import java.util.stream.Collectors;

public class BytecodeAttributes {
    private final BytecodeAttributeInfo[] attributes;
    private final BytecodeAnnotationAttributeInfo[] annotations;

    public BytecodeAttributes(BytecodeAttributeInfo[] aAttributes) {
        this.attributes = aAttributes;
        this.annotations = Arrays.stream(aAttributes).filter(t -> t instanceof BytecodeAnnotationAttributeInfo).map(t -> (BytecodeAnnotationAttributeInfo)t).collect(Collectors.toList()).toArray(new BytecodeAnnotationAttributeInfo[0]);
    }

    public BytecodeAnnotation getAnnotationByType(String aTypeName) {
        for (BytecodeAnnotationAttributeInfo theAnnotationInfo : this.annotations) {
            BytecodeAnnotation theFound = theAnnotationInfo.getAnnotationByType(aTypeName);
            if (theFound == null) continue;
            return theFound;
        }
        return null;
    }

    public <T extends BytecodeAttributeInfo> T getByType(Class<T> aType) {
        for (BytecodeAttributeInfo theInfo : this.attributes) {
            if (theInfo.getClass() != aType) continue;
            return (T)theInfo;
        }
        return null;
    }
}

