/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeTypeRef;

public class BytecodeArrayTypeRef
implements BytecodeTypeRef {
    private final BytecodeTypeRef type;
    private final int depth;

    public BytecodeArrayTypeRef(BytecodeTypeRef aType, int aDepth) {
        this.type = aType;
        this.depth = aDepth;
    }

    @Override
    public String name() {
        return "L" + this.depth + this.type.name();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public BytecodeTypeRef singleElementType() {
        if (this.depth == 1) {
            return this.type;
        }
        return new BytecodeArrayTypeRef(this.type, this.depth - 1);
    }

    public BytecodeTypeRef getType() {
        return this.type;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean matchesExactlyTo(BytecodeTypeRef aOtherType) {
        if (!(aOtherType instanceof BytecodeArrayTypeRef)) {
            return false;
        }
        BytecodeArrayTypeRef theOther = (BytecodeArrayTypeRef)aOtherType;
        if (!this.type.matchesExactlyTo(((BytecodeArrayTypeRef)aOtherType).type)) {
            return false;
        }
        return this.depth == theOther.getDepth();
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public Object defaultValue() {
        return null;
    }
}

