/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeIntegerConstant;
import de.mirkosertic.bytecoder.core.BytecodeSignatureParser;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import java.util.Objects;

public class BytecodeAnnotation {
    private final int typeIndex;
    private final ElementValuePair[] elementValuePairs;
    private final BytecodeConstantPool constantPool;
    private final BytecodeSignatureParser signatureParser;

    public BytecodeAnnotation(int aTypeIndex, ElementValuePair[] aElementValuePairs, BytecodeConstantPool aConstantPool, BytecodeSignatureParser aSignatureParser) {
        this.typeIndex = aTypeIndex;
        this.elementValuePairs = aElementValuePairs;
        this.constantPool = aConstantPool;
        this.signatureParser = aSignatureParser;
    }

    public BytecodeTypeRef getType() {
        BytecodeUtf8Constant theConstant = (BytecodeUtf8Constant)this.constantPool.constantByIndex(this.typeIndex - 1);
        BytecodeTypeRef[] theRefs = this.signatureParser.toTypes(theConstant.stringValue());
        return theRefs[0];
    }

    public ElementValue getElementValueByName(String aAttributeName) {
        for (ElementValuePair thePair : this.elementValuePairs) {
            if (!Objects.equals(thePair.getName().stringValue(), aAttributeName)) continue;
            return thePair.getValue();
        }
        return null;
    }

    public static class ElementValuePair {
        private final int elementNameIndex;
        private final ElementValue elementValue;
        private final BytecodeConstantPool constantPool;

        public ElementValuePair(int aElementNameIndex, ElementValue aElementValue, BytecodeConstantPool aConstantPool) {
            this.elementNameIndex = aElementNameIndex;
            this.elementValue = aElementValue;
            this.constantPool = aConstantPool;
        }

        public BytecodeUtf8Constant getName() {
            return (BytecodeUtf8Constant)this.constantPool.constantByIndex(this.elementNameIndex - 1);
        }

        public ElementValue getValue() {
            return this.elementValue;
        }
    }

    public static class AnnotationElementValueElementValue
    implements ElementValue {
        public AnnotationElementValueElementValue(BytecodeConstantPool aConstantPool, BytecodeAnnotation annotation) {
        }

        @Override
        public String stringValue() {
            throw new IllegalStateException("Not implemented yet");
        }
    }

    public static class ArrayElementValue
    implements ElementValue {
        public ArrayElementValue(BytecodeConstantPool aConstantPool, ElementValue[] aValues) {
        }

        @Override
        public String stringValue() {
            throw new IllegalStateException("Not implemented yet");
        }
    }

    public static class EnumElementValue
    implements ElementValue {
        public EnumElementValue(BytecodeConstantPool aConstantPool, int aTypeNameIndex, int aConstNameIndex) {
        }

        @Override
        public String stringValue() {
            throw new IllegalStateException("Not implemented yet");
        }
    }

    public static class ClassElementValue
    implements ElementValue {
        private final int classInfoIndex;
        private final BytecodeConstantPool constantPool;
        private final BytecodeSignatureParser signatureParser;

        public ClassElementValue(int aClassInfoIndex, BytecodeConstantPool aConstantPool, BytecodeSignatureParser aSignatureParser) {
            this.classInfoIndex = aClassInfoIndex;
            this.constantPool = aConstantPool;
            this.signatureParser = aSignatureParser;
        }

        @Override
        public String stringValue() {
            BytecodeUtf8Constant theConstant = (BytecodeUtf8Constant)this.constantPool.constantByIndex(this.classInfoIndex - 1);
            BytecodeTypeRef[] theTypes = this.signatureParser.toTypes(theConstant.stringValue());
            return theTypes[0].name();
        }
    }

    public static class IntegerElementValue
    implements ElementValue {
        private final int constValueIndex;
        private final BytecodeConstantPool constantPool;

        public IntegerElementValue(int aConstValueIndex, BytecodeConstantPool aConstantPool) {
            this.constValueIndex = aConstValueIndex;
            this.constantPool = aConstantPool;
        }

        @Override
        public String stringValue() {
            return Integer.toString(this.intVakue());
        }

        public int intVakue() {
            BytecodeIntegerConstant theInt = (BytecodeIntegerConstant)this.constantPool.constantByIndex(this.constValueIndex - 1);
            return theInt.getIntegerValue();
        }
    }

    public static class BooleanElementValue
    implements ElementValue {
        private final int constValueIndex;
        private final BytecodeConstantPool constantPool;

        public BooleanElementValue(int aConstValueIndex, BytecodeConstantPool aConstantPool) {
            this.constValueIndex = aConstValueIndex;
            this.constantPool = aConstantPool;
        }

        @Override
        public String stringValue() {
            BytecodeIntegerConstant theConstant = (BytecodeIntegerConstant)this.constantPool.constantByIndex(this.constValueIndex - 1);
            if (theConstant.getIntegerValue() == 1) {
                return "true";
            }
            return "false";
        }
    }

    public static class StringElementValue
    implements ElementValue {
        private final int constValueIndex;
        private final BytecodeConstantPool constantPool;

        public StringElementValue(int aConstValueIndex, BytecodeConstantPool aConstantPool) {
            this.constValueIndex = aConstValueIndex;
            this.constantPool = aConstantPool;
        }

        @Override
        public String stringValue() {
            BytecodeUtf8Constant theString = (BytecodeUtf8Constant)this.constantPool.constantByIndex(this.constValueIndex - 1);
            return theString.stringValue();
        }
    }

    public static interface ElementValue {
        public String stringValue();
    }
}

