/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.api.IsObject;
import de.mirkosertic.bytecoder.core.BytecodeAccessFlags;
import de.mirkosertic.bytecoder.core.BytecodeAnnotation;
import de.mirkosertic.bytecoder.core.BytecodeAnnotationAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeAttributes;
import de.mirkosertic.bytecoder.core.BytecodeBootstrapMethod;
import de.mirkosertic.bytecoder.core.BytecodeBootstrapMethodsAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeClass;
import de.mirkosertic.bytecoder.core.BytecodeClassIndex;
import de.mirkosertic.bytecoder.core.BytecodeClassParser;
import de.mirkosertic.bytecoder.core.BytecodeClassinfoConstant;
import de.mirkosertic.bytecoder.core.BytecodeCodeAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeConstant;
import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeDescriptorIndex;
import de.mirkosertic.bytecoder.core.BytecodeDoubleConstant;
import de.mirkosertic.bytecoder.core.BytecodeExceptionTableEntry;
import de.mirkosertic.bytecoder.core.BytecodeField;
import de.mirkosertic.bytecoder.core.BytecodeFieldRefConstant;
import de.mirkosertic.bytecoder.core.BytecodeFloatConstant;
import de.mirkosertic.bytecoder.core.BytecodeIntegerConstant;
import de.mirkosertic.bytecoder.core.BytecodeInterface;
import de.mirkosertic.bytecoder.core.BytecodeInterfaceRefConstant;
import de.mirkosertic.bytecoder.core.BytecodeInvokeDynamicConstant;
import de.mirkosertic.bytecoder.core.BytecodeLineNumberTableAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeLocalVariableTableAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeLocalVariableTableEntry;
import de.mirkosertic.bytecoder.core.BytecodeLongConstant;
import de.mirkosertic.bytecoder.core.BytecodeMethod;
import de.mirkosertic.bytecoder.core.BytecodeMethodAttributeIndex;
import de.mirkosertic.bytecoder.core.BytecodeMethodHandleConstant;
import de.mirkosertic.bytecoder.core.BytecodeMethodRefConstant;
import de.mirkosertic.bytecoder.core.BytecodeMethodTypeConstant;
import de.mirkosertic.bytecoder.core.BytecodeNameAndTypeConstant;
import de.mirkosertic.bytecoder.core.BytecodeNameAndTypeIndex;
import de.mirkosertic.bytecoder.core.BytecodeNameIndex;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeProgram;
import de.mirkosertic.bytecoder.core.BytecodeProgramParser;
import de.mirkosertic.bytecoder.core.BytecodeReferenceIndex;
import de.mirkosertic.bytecoder.core.BytecodeReferenceKind;
import de.mirkosertic.bytecoder.core.BytecodeReplacer;
import de.mirkosertic.bytecoder.core.BytecodeSignatureParser;
import de.mirkosertic.bytecoder.core.BytecodeSourceFileAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeStringConstant;
import de.mirkosertic.bytecoder.core.BytecodeStringIndex;
import de.mirkosertic.bytecoder.core.BytecodeTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeUnknownAttributeInfo;
import de.mirkosertic.bytecoder.core.BytecodeUnusedConstant;
import de.mirkosertic.bytecoder.core.BytecodeUtf8Constant;
import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class Bytecode5xClassParser
implements BytecodeClassParser {
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_MethodHandle = 15;
    private static final int CONSTANT_MethodType = 16;
    private static final int CONSTANT_InvokeDynamic = 18;
    private final BytecodeProgramParser programmParser;
    private final BytecodeSignatureParser signatureParser;
    private final BytecodeReplacer bytecodeReplacer;

    public Bytecode5xClassParser(BytecodeProgramParser aParser, BytecodeSignatureParser aSignatureParser, BytecodeReplacer aReplacer) {
        this.programmParser = aParser;
        this.signatureParser = aSignatureParser;
        this.bytecodeReplacer = aReplacer;
    }

    @Override
    public BytecodeClass parseBody(DataInput dis) throws IOException {
        BytecodeConstantPool theConstantPool = this.parseConstantPool(dis);
        BytecodeAccessFlags theAccessFlags = this.parseAccessFlags(dis);
        BytecodeClassinfoConstant theThisClass = this.parseThisClass(dis, theConstantPool);
        BytecodeClassinfoConstant theSuperClass = this.parseSuperClass(dis, theConstantPool);
        BytecodeInterface[] theInterfaces = this.parseInterfaces(dis, theConstantPool);
        BytecodeField[] theFields = this.parseFields(dis, theConstantPool);
        BytecodeMethod[] theMethods = this.parseMethods(dis, theConstantPool);
        BytecodeAttributeInfo[] theClassAttributes = this.parseAttributes(dis, theConstantPool);
        BytecodeAttributes theAttributes = new BytecodeAttributes(theClassAttributes);
        if (theAttributes.getAnnotationByType(IsObject.class.getName()) != null) {
            theSuperClass = BytecodeClassinfoConstant.OBJECT_CLASS;
        }
        BytecodeReplacer.MergeResult theResult = this.bytecodeReplacer.replace(theThisClass, theMethods, theFields, theSuperClass, theInterfaces, theClassAttributes);
        return new BytecodeClass(theConstantPool, theAccessFlags, theThisClass, theSuperClass, theInterfaces, theResult.getFields(), theResult.getMethods(), theResult.getClassAttributes());
    }

    private BytecodeConstantPool parseConstantPool(DataInput aDis) throws IOException {
        BytecodeConstantPool theResult = new BytecodeConstantPool();
        int theConstantPoolCount = aDis.readUnsignedShort();
        block16: for (int i = 1; i < theConstantPoolCount; ++i) {
            int theTag = aDis.readUnsignedByte();
            switch (theTag) {
                case 7: {
                    this.parseConstantPool_CONSTANT_Class(aDis, theResult);
                    continue block16;
                }
                case 9: {
                    this.parseConstantPool_CONSTANT_Fieldref(aDis, theResult);
                    continue block16;
                }
                case 10: {
                    this.parseConstantPool_CONSTANT_Methodref(aDis, theResult);
                    continue block16;
                }
                case 11: {
                    this.parseConstantPool_CONSTANT_InterfaceMethodref(aDis, theResult);
                    continue block16;
                }
                case 8: {
                    this.parseConstantPool_CONSTANT_String(aDis, theResult);
                    continue block16;
                }
                case 3: {
                    this.parseConstantPool_CONSTANT_Integer(aDis, theResult);
                    continue block16;
                }
                case 4: {
                    this.parseConstantPool_CONSTANT_Float(aDis, theResult);
                    continue block16;
                }
                case 5: {
                    this.parseConstantPool_CONSTANT_Long(aDis, theResult);
                    theResult.registerConstant(new BytecodeUnusedConstant());
                    ++i;
                    continue block16;
                }
                case 6: {
                    this.parseConstantPool_CONSTANT_Double(aDis, theResult);
                    theResult.registerConstant(new BytecodeUnusedConstant());
                    ++i;
                    continue block16;
                }
                case 12: {
                    this.parseConstantPool_CONSTANT_NameAndType(aDis, theResult);
                    continue block16;
                }
                case 1: {
                    this.parseConstantPool_CONSTANT_Utf8(aDis, theResult);
                    continue block16;
                }
                case 15: {
                    this.parseConstantPool_CONSTANT_MethodHandle(aDis, theResult);
                    continue block16;
                }
                case 16: {
                    this.parseConstantPool_CONSTANT_MethodType(aDis, theResult);
                    continue block16;
                }
                case 18: {
                    this.parseConstantPool_CONSTANT_InvokeDynamic(aDis, theResult);
                    continue block16;
                }
                default: {
                    throw new IllegalStateException("Unknown constant pool tag : " + theTag + " for index " + i + " of " + theConstantPoolCount);
                }
            }
        }
        return theResult;
    }

    private void parseConstantPool_CONSTANT_Class(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theNameIndex = aDis.readUnsignedShort();
        aConstantPool.registerConstant(new BytecodeClassinfoConstant(theNameIndex, aConstantPool, this.bytecodeReplacer));
    }

    private void parseConstantPool_CONSTANT_Fieldref(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theClassIndex = aDis.readUnsignedShort();
        int theNameAndTypeIndex = aDis.readUnsignedShort();
        aConstantPool.registerConstant(new BytecodeFieldRefConstant(new BytecodeClassIndex(theClassIndex, aConstantPool), new BytecodeNameAndTypeIndex(theNameAndTypeIndex, aConstantPool)));
    }

    private void parseConstantPool_CONSTANT_Methodref(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theClassIndex = aDis.readUnsignedShort();
        int theNameAndTypeIndex = aDis.readUnsignedShort();
        aConstantPool.registerConstant(new BytecodeMethodRefConstant(new BytecodeClassIndex(theClassIndex, aConstantPool), new BytecodeNameAndTypeIndex(theNameAndTypeIndex, aConstantPool)));
    }

    private void parseConstantPool_CONSTANT_InterfaceMethodref(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theClassIndex = aDis.readUnsignedShort();
        int theNameAndTypeIndex = aDis.readUnsignedShort();
        aConstantPool.registerConstant(new BytecodeInterfaceRefConstant(new BytecodeClassIndex(theClassIndex, aConstantPool), new BytecodeNameAndTypeIndex(theNameAndTypeIndex, aConstantPool)));
    }

    private void parseConstantPool_CONSTANT_String(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theStringIndex = aDis.readUnsignedShort();
        aConstantPool.registerConstant(new BytecodeStringConstant(new BytecodeStringIndex(theStringIndex), aConstantPool));
    }

    private void parseConstantPool_CONSTANT_Integer(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theBytes = aDis.readInt();
        aConstantPool.registerConstant(new BytecodeIntegerConstant(theBytes));
    }

    private void parseConstantPool_CONSTANT_Float(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        float theFloat = aDis.readFloat();
        aConstantPool.registerConstant(new BytecodeFloatConstant(theFloat));
    }

    private void parseConstantPool_CONSTANT_Long(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        long theLowBytes = (long)aDis.readInt() & 0xFFFFFFFFL;
        long theHighBytes = (long)aDis.readInt() & 0xFFFFFFFFL;
        aConstantPool.registerConstant(new BytecodeLongConstant(theHighBytes, theLowBytes));
    }

    private void parseConstantPool_CONSTANT_Double(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        double theDouble = aDis.readDouble();
        aConstantPool.registerConstant(new BytecodeDoubleConstant(theDouble));
    }

    private void parseConstantPool_CONSTANT_NameAndType(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theNameIndex = aDis.readUnsignedShort();
        int theDescriptorIndex = aDis.readUnsignedShort();
        aConstantPool.registerConstant(new BytecodeNameAndTypeConstant(new BytecodeNameIndex(theNameIndex, aConstantPool), new BytecodeDescriptorIndex(theDescriptorIndex, aConstantPool, this.signatureParser)));
    }

    private void parseConstantPool_CONSTANT_Utf8(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theLength = aDis.readUnsignedShort();
        byte[] theData = new byte[theLength];
        aDis.readFully(theData);
        aConstantPool.registerConstant(new BytecodeUtf8Constant(new String(theData, StandardCharsets.UTF_8)));
    }

    private void parseConstantPool_CONSTANT_MethodHandle(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theReferenceKind = aDis.readUnsignedByte();
        int theReferenceIndex = aDis.readUnsignedShort();
        switch (theReferenceKind) {
            case 1: {
                aConstantPool.registerConstant(new BytecodeMethodHandleConstant(BytecodeReferenceKind.REF_getField, new BytecodeReferenceIndex(theReferenceIndex, aConstantPool)));
                break;
            }
            case 2: {
                aConstantPool.registerConstant(new BytecodeMethodHandleConstant(BytecodeReferenceKind.REF_getStatic, new BytecodeReferenceIndex(theReferenceIndex, aConstantPool)));
                break;
            }
            case 3: {
                aConstantPool.registerConstant(new BytecodeMethodHandleConstant(BytecodeReferenceKind.REF_putField, new BytecodeReferenceIndex(theReferenceIndex, aConstantPool)));
                break;
            }
            case 4: {
                aConstantPool.registerConstant(new BytecodeMethodHandleConstant(BytecodeReferenceKind.REF_putStatic, new BytecodeReferenceIndex(theReferenceIndex, aConstantPool)));
                break;
            }
            case 5: {
                aConstantPool.registerConstant(new BytecodeMethodHandleConstant(BytecodeReferenceKind.REF_invokeVirtual, new BytecodeReferenceIndex(theReferenceIndex, aConstantPool)));
                break;
            }
            case 6: {
                aConstantPool.registerConstant(new BytecodeMethodHandleConstant(BytecodeReferenceKind.REF_invokeStatic, new BytecodeReferenceIndex(theReferenceIndex, aConstantPool)));
                break;
            }
            case 7: {
                aConstantPool.registerConstant(new BytecodeMethodHandleConstant(BytecodeReferenceKind.REF_invokeSpecial, new BytecodeReferenceIndex(theReferenceIndex, aConstantPool)));
                break;
            }
            case 8: {
                aConstantPool.registerConstant(new BytecodeMethodHandleConstant(BytecodeReferenceKind.REF_newInvokeSpecial, new BytecodeReferenceIndex(theReferenceIndex, aConstantPool)));
                break;
            }
            case 9: {
                aConstantPool.registerConstant(new BytecodeMethodHandleConstant(BytecodeReferenceKind.REF_invokeInterface, new BytecodeReferenceIndex(theReferenceIndex, aConstantPool)));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown reference kind : " + theReferenceKind);
            }
        }
    }

    private void parseConstantPool_CONSTANT_MethodType(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theDescriptorIndex = aDis.readUnsignedShort();
        aConstantPool.registerConstant(new BytecodeMethodTypeConstant(new BytecodeDescriptorIndex(theDescriptorIndex, aConstantPool, this.signatureParser)));
    }

    private void parseConstantPool_CONSTANT_InvokeDynamic(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theBootstrapMethodAttrIndex = aDis.readUnsignedShort();
        int theNameAndTypeIndex = aDis.readUnsignedShort();
        aConstantPool.registerConstant(new BytecodeInvokeDynamicConstant(new BytecodeMethodAttributeIndex(theBootstrapMethodAttrIndex), new BytecodeNameAndTypeIndex(theNameAndTypeIndex, aConstantPool)));
    }

    private BytecodeAccessFlags parseAccessFlags(DataInput aDis) throws IOException {
        int theAccessFlags = aDis.readUnsignedShort();
        return new BytecodeAccessFlags(theAccessFlags);
    }

    private BytecodeClassinfoConstant parseThisClass(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theThisClass = aDis.readUnsignedShort();
        BytecodeConstant theConstant = aConstantPool.constantByIndex(theThisClass - 1);
        if (!(theConstant instanceof BytecodeClassinfoConstant)) {
            throw new IllegalStateException("Invalid this constant reference : got type " + theConstant.getClass().getName());
        }
        return (BytecodeClassinfoConstant)theConstant;
    }

    private BytecodeClassinfoConstant parseSuperClass(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theSuperClass = aDis.readUnsignedShort();
        if (theSuperClass == 0) {
            return BytecodeClassinfoConstant.OBJECT_CLASS;
        }
        BytecodeConstant theConstant = aConstantPool.constantByIndex(theSuperClass - 1);
        if (!(theConstant instanceof BytecodeClassinfoConstant)) {
            throw new IllegalStateException("Invalid super_class constant reference : got type " + theConstant.getClass().getName());
        }
        return (BytecodeClassinfoConstant)theConstant;
    }

    private BytecodeInterface[] parseInterfaces(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        ArrayList<BytecodeInterface> theInterfaces = new ArrayList<BytecodeInterface>();
        int theInterfaceCount = aDis.readUnsignedShort();
        for (int i = 0; i < theInterfaceCount; ++i) {
            int theNameIndex = aDis.readUnsignedShort();
            BytecodeConstant theConstant = aConstantPool.constantByIndex(theNameIndex - 1);
            if (!(theConstant instanceof BytecodeClassinfoConstant)) {
                throw new IllegalStateException("Invalid constant reference : got type " + theConstant.getClass().getName());
            }
            theInterfaces.add(new BytecodeInterface((BytecodeClassinfoConstant)theConstant));
        }
        return theInterfaces.toArray(new BytecodeInterface[theInterfaces.size()]);
    }

    private BytecodeBootstrapMethodsAttributeInfo parseBootstrapAttribute(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theNumMethods = aDis.readUnsignedShort();
        ArrayList<BytecodeBootstrapMethod> theMethods = new ArrayList<BytecodeBootstrapMethod>();
        for (int i = 0; i < theNumMethods; ++i) {
            int theMethodRef = aDis.readUnsignedShort();
            int theNumArguments = aDis.readUnsignedShort();
            int[] theArguments = new int[theNumArguments];
            for (int j = 0; j < theNumArguments; ++j) {
                theArguments[j] = aDis.readUnsignedShort();
            }
            theMethods.add(new BytecodeBootstrapMethod(theMethodRef, theArguments, aConstantPool));
        }
        return new BytecodeBootstrapMethodsAttributeInfo(theMethods.toArray(new BytecodeBootstrapMethod[theMethods.size()]));
    }

    private BytecodeSourceFileAttributeInfo parseSourceFileAttribute(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theNameIndex = aDis.readUnsignedShort();
        return new BytecodeSourceFileAttributeInfo(aConstantPool, theNameIndex);
    }

    private BytecodeLineNumberTableAttributeInfo parseLineNumberTableAttribute(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theNumEntries = aDis.readUnsignedShort();
        BytecodeLineNumberTableAttributeInfo.Entry[] theEntries = new BytecodeLineNumberTableAttributeInfo.Entry[theNumEntries];
        for (int i = 0; i < theNumEntries; ++i) {
            int theStartPC = aDis.readUnsignedShort();
            int theLineNum = aDis.readUnsignedShort();
            theEntries[i] = new BytecodeLineNumberTableAttributeInfo.Entry(theStartPC, theLineNum);
        }
        return new BytecodeLineNumberTableAttributeInfo(theEntries);
    }

    private BytecodeLocalVariableTableAttributeInfo parseLocalVariableTableAttribute(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theNumTableEntries = aDis.readUnsignedShort();
        ArrayList<BytecodeLocalVariableTableEntry> theEntries = new ArrayList<BytecodeLocalVariableTableEntry>();
        for (int i = 0; i < theNumTableEntries; ++i) {
            int theStartPC = aDis.readUnsignedShort();
            int theLength = aDis.readUnsignedShort();
            int theNameIndex = aDis.readUnsignedShort();
            int theDescriptorIndex = aDis.readUnsignedShort();
            int theIndex = aDis.readUnsignedShort();
            BytecodeTypeRef theTypeRef = this.signatureParser.toFieldType((BytecodeUtf8Constant)aConstantPool.constantByIndex(theDescriptorIndex - 1));
            theEntries.add(new BytecodeLocalVariableTableEntry(theStartPC, theLength, theNameIndex, theTypeRef, theIndex));
        }
        return new BytecodeLocalVariableTableAttributeInfo(aConstantPool, theEntries.toArray(new BytecodeLocalVariableTableEntry[theEntries.size()]));
    }

    private BytecodeAnnotation.ElementValue readAnnotationElementValueFrom(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        char theTag = (char)aDis.readUnsignedByte();
        switch (theTag) {
            case 's': {
                int theConstValueIndex = aDis.readUnsignedShort();
                return new BytecodeAnnotation.StringElementValue(theConstValueIndex, aConstantPool);
            }
            case 'I': {
                int theConstValueIndex = aDis.readUnsignedShort();
                return new BytecodeAnnotation.IntegerElementValue(theConstValueIndex, aConstantPool);
            }
            case 'c': {
                int theClassInfoIndex = aDis.readUnsignedShort();
                return new BytecodeAnnotation.ClassElementValue(theClassInfoIndex, aConstantPool, this.signatureParser);
            }
            case 'Z': {
                int theClassInfoIndex = aDis.readUnsignedShort();
                return new BytecodeAnnotation.BooleanElementValue(theClassInfoIndex, aConstantPool);
            }
            case 'e': {
                int theTypeNameIndex = aDis.readUnsignedShort();
                int theConstNameIndex = aDis.readUnsignedShort();
                return new BytecodeAnnotation.EnumElementValue(aConstantPool, theTypeNameIndex, theConstNameIndex);
            }
            case '[': {
                int theLength = aDis.readUnsignedShort();
                BytecodeAnnotation.ElementValue[] theValues = new BytecodeAnnotation.ElementValue[theLength];
                for (int i = 0; i < theLength; ++i) {
                    theValues[i] = this.readAnnotationElementValueFrom(aDis, aConstantPool);
                }
                return new BytecodeAnnotation.ArrayElementValue(aConstantPool, theValues);
            }
            case '@': {
                BytecodeAnnotation theAnnotation = this.readSingleAnnotation(aDis, aConstantPool);
                return new BytecodeAnnotation.AnnotationElementValueElementValue(aConstantPool, theAnnotation);
            }
        }
        throw new IllegalArgumentException("Not supported annotation value type : " + theTag);
    }

    private BytecodeAnnotationAttributeInfo parseAnnotationAttribute(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theAnnotationCount = aDis.readUnsignedShort();
        ArrayList<BytecodeAnnotation> theAnnotations = new ArrayList<BytecodeAnnotation>();
        for (int i = 0; i < theAnnotationCount; ++i) {
            theAnnotations.add(this.readSingleAnnotation(aDis, aConstantPool));
        }
        return new BytecodeAnnotationAttributeInfo(theAnnotations.toArray(new BytecodeAnnotation[theAnnotations.size()]));
    }

    private BytecodeAnnotation readSingleAnnotation(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theTypeIndex = aDis.readUnsignedShort();
        int theNumElementValuePairs = aDis.readUnsignedShort();
        ArrayList<BytecodeAnnotation.ElementValuePair> theElementValuePairs = new ArrayList<BytecodeAnnotation.ElementValuePair>();
        for (int j = 0; j < theNumElementValuePairs; ++j) {
            int theElementNameIndex = aDis.readUnsignedShort();
            BytecodeAnnotation.ElementValue theAnnotationValue = this.readAnnotationElementValueFrom(aDis, aConstantPool);
            theElementValuePairs.add(new BytecodeAnnotation.ElementValuePair(theElementNameIndex, theAnnotationValue, aConstantPool));
        }
        return new BytecodeAnnotation(theTypeIndex, theElementValuePairs.toArray(new BytecodeAnnotation.ElementValuePair[theElementValuePairs.size()]), aConstantPool, this.signatureParser);
    }

    private BytecodeCodeAttributeInfo parseCodeAttribute(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        int theMaxStack = aDis.readUnsignedShort();
        int theMaxLocals = aDis.readUnsignedShort();
        int theCodeLength = aDis.readInt();
        byte[] theCode = new byte[theCodeLength];
        aDis.readFully(theCode);
        BytecodeProgram theProgramm = this.programmParser.parse(theCode, aConstantPool);
        int theExceptionTableLength = aDis.readUnsignedShort();
        for (int i = 0; i < theExceptionTableLength; ++i) {
            BytecodeOpcodeAddress theStartPC = new BytecodeOpcodeAddress(aDis.readUnsignedShort());
            BytecodeOpcodeAddress theEndPc = new BytecodeOpcodeAddress(aDis.readUnsignedShort());
            BytecodeOpcodeAddress theHandlerPc = new BytecodeOpcodeAddress(aDis.readUnsignedShort());
            int theCatchType = aDis.readUnsignedShort();
            theProgramm.addExceptionHandler(new BytecodeExceptionTableEntry(theStartPC, theEndPc, theHandlerPc, theCatchType, aConstantPool));
        }
        BytecodeAttributeInfo[] theAttributes = this.parseAttributes(aDis, aConstantPool);
        return new BytecodeCodeAttributeInfo(theMaxStack, theMaxLocals, theProgramm, theAttributes);
    }

    private BytecodeAttributeInfo[] parseAttributes(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        ArrayList<BytecodeAttributeInfo> theAttributes = new ArrayList<BytecodeAttributeInfo>();
        int theAttributesCount = aDis.readUnsignedShort();
        block16: for (int j = 0; j < theAttributesCount; ++j) {
            int theAttributeNameIndex = aDis.readUnsignedShort();
            BytecodeConstant theAttributeNameConstant = aConstantPool.constantByIndex(theAttributeNameIndex - 1);
            if (!(theAttributeNameConstant instanceof BytecodeUtf8Constant)) {
                throw new IllegalStateException("Invalid constant reference : got type " + theAttributeNameConstant.getClass().getName());
            }
            int theAttributeLength = aDis.readInt();
            switch (((BytecodeUtf8Constant)theAttributeNameConstant).stringValue()) {
                case "Code": {
                    theAttributes.add(this.parseCodeAttribute(aDis, aConstantPool));
                    continue block16;
                }
                case "RuntimeVisibleAnnotations": {
                    theAttributes.add(this.parseAnnotationAttribute(aDis, aConstantPool));
                    continue block16;
                }
                case "BootstrapMethods": {
                    theAttributes.add(this.parseBootstrapAttribute(aDis, aConstantPool));
                    continue block16;
                }
                case "LocalVariableTable": {
                    theAttributes.add(this.parseLocalVariableTableAttribute(aDis, aConstantPool));
                    continue block16;
                }
                case "SourceFile": {
                    theAttributes.add(this.parseSourceFileAttribute(aDis, aConstantPool));
                    continue block16;
                }
                case "LineNumberTable": {
                    theAttributes.add(this.parseLineNumberTableAttribute(aDis, aConstantPool));
                    continue block16;
                }
                default: {
                    byte[] theAttributeData = new byte[theAttributeLength];
                    aDis.readFully(theAttributeData);
                    theAttributes.add(new BytecodeUnknownAttributeInfo((BytecodeUtf8Constant)theAttributeNameConstant, theAttributeData));
                }
            }
        }
        return theAttributes.toArray(new BytecodeAttributeInfo[theAttributes.size()]);
    }

    private BytecodeField[] parseFields(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        ArrayList<BytecodeField> theFields = new ArrayList<BytecodeField>();
        int theFieldCount = aDis.readUnsignedShort();
        for (int i = 0; i < theFieldCount; ++i) {
            int theAccessFlags = aDis.readUnsignedShort();
            int theNameIndex = aDis.readUnsignedShort();
            BytecodeConstant theNameConstant = aConstantPool.constantByIndex(theNameIndex - 1);
            if (!(theNameConstant instanceof BytecodeUtf8Constant)) {
                throw new IllegalStateException("Invalid interface constant reference : got type " + theNameConstant.getClass().getName());
            }
            int theDescriptorIndex = aDis.readUnsignedShort();
            BytecodeConstant theDescriptorConstant = aConstantPool.constantByIndex(theDescriptorIndex - 1);
            if (!(theDescriptorConstant instanceof BytecodeUtf8Constant)) {
                throw new IllegalStateException("Invalid interface constant reference : got type " + theDescriptorConstant.getClass().getName());
            }
            BytecodeAttributeInfo[] theAttributes = this.parseAttributes(aDis, aConstantPool);
            BytecodeTypeRef theTypeRef = this.signatureParser.toFieldType((BytecodeUtf8Constant)theDescriptorConstant);
            theFields.add(new BytecodeField(new BytecodeAccessFlags(theAccessFlags), (BytecodeUtf8Constant)theNameConstant, theTypeRef, theAttributes));
        }
        return theFields.toArray(new BytecodeField[theFields.size()]);
    }

    private BytecodeMethod[] parseMethods(DataInput aDis, BytecodeConstantPool aConstantPool) throws IOException {
        ArrayList<BytecodeMethod> theMethods = new ArrayList<BytecodeMethod>();
        int theMethodCount = aDis.readUnsignedShort();
        for (int i = 0; i < theMethodCount; ++i) {
            int theAccessFlags = aDis.readUnsignedShort();
            int theNameIndex = aDis.readUnsignedShort();
            BytecodeConstant theName = aConstantPool.constantByIndex(theNameIndex - 1);
            if (!(theName instanceof BytecodeUtf8Constant)) {
                throw new IllegalStateException("Invalid interface constant reference : got type " + theName.getClass().getName());
            }
            int theDescriptorIndex = aDis.readUnsignedShort();
            BytecodeConstant theDescriptor = aConstantPool.constantByIndex(theDescriptorIndex - 1);
            if (!(theDescriptor instanceof BytecodeUtf8Constant)) {
                throw new IllegalStateException("Invalid interface constant reference : got type " + theDescriptor.getClass().getName());
            }
            BytecodeAttributeInfo[] theAttributes = this.parseAttributes(aDis, aConstantPool);
            theMethods.add(new BytecodeMethod(new BytecodeAccessFlags(theAccessFlags), (BytecodeUtf8Constant)theName, this.signatureParser.toMethodSignature((BytecodeUtf8Constant)theDescriptor), theAttributes));
        }
        return theMethods.toArray(new BytecodeMethod[theMethods.size()]);
    }
}

