/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.core;

import de.mirkosertic.bytecoder.core.BytecodeConstantPool;
import de.mirkosertic.bytecoder.core.BytecodeInstructionACONSTNULL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionALOAD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionANEWARRAY;
import de.mirkosertic.bytecoder.core.BytecodeInstructionARRAYLENGTH;
import de.mirkosertic.bytecoder.core.BytecodeInstructionASTORE;
import de.mirkosertic.bytecoder.core.BytecodeInstructionATHROW;
import de.mirkosertic.bytecoder.core.BytecodeInstructionBIPUSH;
import de.mirkosertic.bytecoder.core.BytecodeInstructionCHECKCAST;
import de.mirkosertic.bytecoder.core.BytecodeInstructionD2Generic;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDCONST;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUP2;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUP2X1;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUP2X2;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUPX1;
import de.mirkosertic.bytecoder.core.BytecodeInstructionDUPX2;
import de.mirkosertic.bytecoder.core.BytecodeInstructionF2Generic;
import de.mirkosertic.bytecoder.core.BytecodeInstructionFCONST;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGETFIELD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGETSTATIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGOTO;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericADD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericAND;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericArrayLOAD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericArraySTORE;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericCMP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericDIV;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericLDC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericLOAD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericMUL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericNEG;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericOR;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericREM;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericRETURN;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericSHL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericSHR;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericSTORE;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericSUB;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericUSHR;
import de.mirkosertic.bytecoder.core.BytecodeInstructionGenericXOR;
import de.mirkosertic.bytecoder.core.BytecodeInstructionI2Generic;
import de.mirkosertic.bytecoder.core.BytecodeInstructionICONST;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIFACMP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIFCOND;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIFICMP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIFNONNULL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIFNULL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionIINC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINSTANCEOF;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKEDYNAMIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKEINTERFACE;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKESPECIAL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKESTATIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionINVOKEVIRTUAL;
import de.mirkosertic.bytecoder.core.BytecodeInstructionJSR;
import de.mirkosertic.bytecoder.core.BytecodeInstructionL2Generic;
import de.mirkosertic.bytecoder.core.BytecodeInstructionLCMP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionLCONST;
import de.mirkosertic.bytecoder.core.BytecodeInstructionLOOKUPSWITCH;
import de.mirkosertic.bytecoder.core.BytecodeInstructionMONITORENTER;
import de.mirkosertic.bytecoder.core.BytecodeInstructionMONITOREXIT;
import de.mirkosertic.bytecoder.core.BytecodeInstructionNEW;
import de.mirkosertic.bytecoder.core.BytecodeInstructionNEWARRAY;
import de.mirkosertic.bytecoder.core.BytecodeInstructionNEWMULTIARRAY;
import de.mirkosertic.bytecoder.core.BytecodeInstructionNOP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionObjectArrayLOAD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionObjectArraySTORE;
import de.mirkosertic.bytecoder.core.BytecodeInstructionObjectRETURN;
import de.mirkosertic.bytecoder.core.BytecodeInstructionPOP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionPOP2;
import de.mirkosertic.bytecoder.core.BytecodeInstructionPUTFIELD;
import de.mirkosertic.bytecoder.core.BytecodeInstructionPUTSTATIC;
import de.mirkosertic.bytecoder.core.BytecodeInstructionRET;
import de.mirkosertic.bytecoder.core.BytecodeInstructionRETURN;
import de.mirkosertic.bytecoder.core.BytecodeInstructionSIPUSH;
import de.mirkosertic.bytecoder.core.BytecodeInstructionSWAP;
import de.mirkosertic.bytecoder.core.BytecodeInstructionTABLESWITCH;
import de.mirkosertic.bytecoder.core.BytecodeOpcodeAddress;
import de.mirkosertic.bytecoder.core.BytecodeParserUtils;
import de.mirkosertic.bytecoder.core.BytecodePrimitiveTypeRef;
import de.mirkosertic.bytecoder.core.BytecodeProgram;
import de.mirkosertic.bytecoder.core.BytecodeProgramParser;

public class Bytecode5XProgramParser
implements BytecodeProgramParser {
    @Override
    public BytecodeProgram parse(byte[] aBytecodes, BytecodeConstantPool aConstantPool) {
        BytecodeProgram theResult = new BytecodeProgram();
        int offset = 0;
        boolean wide = false;
        block212: while (offset < aBytecodes.length) {
            BytecodeOpcodeAddress theOpcodeIndex = new BytecodeOpcodeAddress(offset);
            int theOpcode = aBytecodes[offset++] & 0xFF;
            boolean isWideOperator = wide;
            wide = false;
            switch (theOpcode) {
                case 0: {
                    theResult.addInstruction(new BytecodeInstructionNOP(theOpcodeIndex));
                    continue block212;
                }
                case 1: {
                    theResult.addInstruction(new BytecodeInstructionACONSTNULL(theOpcodeIndex));
                    continue block212;
                }
                case 2: {
                    theResult.addInstruction(new BytecodeInstructionICONST(theOpcodeIndex, -1));
                    continue block212;
                }
                case 3: {
                    theResult.addInstruction(new BytecodeInstructionICONST(theOpcodeIndex, 0));
                    continue block212;
                }
                case 4: {
                    theResult.addInstruction(new BytecodeInstructionICONST(theOpcodeIndex, 1));
                    continue block212;
                }
                case 5: {
                    theResult.addInstruction(new BytecodeInstructionICONST(theOpcodeIndex, 2));
                    continue block212;
                }
                case 6: {
                    theResult.addInstruction(new BytecodeInstructionICONST(theOpcodeIndex, 3));
                    continue block212;
                }
                case 7: {
                    theResult.addInstruction(new BytecodeInstructionICONST(theOpcodeIndex, 4));
                    continue block212;
                }
                case 8: {
                    theResult.addInstruction(new BytecodeInstructionICONST(theOpcodeIndex, 5));
                    continue block212;
                }
                case 9: {
                    theResult.addInstruction(new BytecodeInstructionLCONST(theOpcodeIndex, 0L));
                    continue block212;
                }
                case 10: {
                    theResult.addInstruction(new BytecodeInstructionLCONST(theOpcodeIndex, 1L));
                    continue block212;
                }
                case 11: {
                    theResult.addInstruction(new BytecodeInstructionFCONST(theOpcodeIndex, 0.0f));
                    continue block212;
                }
                case 12: {
                    theResult.addInstruction(new BytecodeInstructionFCONST(theOpcodeIndex, 1.0f));
                    continue block212;
                }
                case 13: {
                    theResult.addInstruction(new BytecodeInstructionFCONST(theOpcodeIndex, 2.0f));
                    continue block212;
                }
                case 14: {
                    theResult.addInstruction(new BytecodeInstructionDCONST(theOpcodeIndex, 0.0));
                    continue block212;
                }
                case 15: {
                    theResult.addInstruction(new BytecodeInstructionDCONST(theOpcodeIndex, 1.0));
                    continue block212;
                }
                case 16: {
                    byte theValue = aBytecodes[offset++];
                    theResult.addInstruction(new BytecodeInstructionBIPUSH(theOpcodeIndex, theValue));
                    continue block212;
                }
                case 17: {
                    short theShortValue = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionSIPUSH(theOpcodeIndex, theShortValue));
                    continue block212;
                }
                case 18: {
                    int theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionGenericLDC(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 19: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionGenericLDC(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 20: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionGenericLDC(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 21: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionGenericLOAD(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress() - 1), BytecodePrimitiveTypeRef.INT, theIndex));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.INT, theIndex));
                    continue block212;
                }
                case 22: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionGenericLOAD(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress() - 1), BytecodePrimitiveTypeRef.LONG, theIndex));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG, theIndex));
                    continue block212;
                }
                case 23: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionGenericLOAD(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress() - 1), BytecodePrimitiveTypeRef.FLOAT, theIndex));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT, theIndex));
                    continue block212;
                }
                case 24: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionGenericLOAD(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress() - 1), BytecodePrimitiveTypeRef.DOUBLE, theIndex));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE, theIndex));
                    continue block212;
                }
                case 25: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionALOAD(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress() - 1), theIndex));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionALOAD(theOpcodeIndex, theIndex));
                    continue block212;
                }
                case 26: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.INT, 0));
                    continue block212;
                }
                case 27: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.INT, 1));
                    continue block212;
                }
                case 28: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.INT, 2));
                    continue block212;
                }
                case 29: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.INT, 3));
                    continue block212;
                }
                case 30: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG, 0));
                    continue block212;
                }
                case 31: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG, 1));
                    continue block212;
                }
                case 32: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG, 2));
                    continue block212;
                }
                case 33: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG, 3));
                    continue block212;
                }
                case 34: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT, 0));
                    continue block212;
                }
                case 35: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT, 1));
                    continue block212;
                }
                case 36: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT, 2));
                    continue block212;
                }
                case 37: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT, 3));
                    continue block212;
                }
                case 38: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE, 0));
                    continue block212;
                }
                case 39: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE, 1));
                    continue block212;
                }
                case 40: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE, 2));
                    continue block212;
                }
                case 41: {
                    theResult.addInstruction(new BytecodeInstructionGenericLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE, 3));
                    continue block212;
                }
                case 42: {
                    theResult.addInstruction(new BytecodeInstructionALOAD(theOpcodeIndex, 0));
                    continue block212;
                }
                case 43: {
                    theResult.addInstruction(new BytecodeInstructionALOAD(theOpcodeIndex, 1));
                    continue block212;
                }
                case 44: {
                    theResult.addInstruction(new BytecodeInstructionALOAD(theOpcodeIndex, 2));
                    continue block212;
                }
                case 45: {
                    theResult.addInstruction(new BytecodeInstructionALOAD(theOpcodeIndex, 3));
                    continue block212;
                }
                case 46: {
                    theResult.addInstruction(new BytecodeInstructionGenericArrayLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 47: {
                    theResult.addInstruction(new BytecodeInstructionGenericArrayLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 48: {
                    theResult.addInstruction(new BytecodeInstructionGenericArrayLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 49: {
                    theResult.addInstruction(new BytecodeInstructionGenericArrayLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 50: {
                    theResult.addInstruction(new BytecodeInstructionObjectArrayLOAD(theOpcodeIndex));
                    continue block212;
                }
                case 51: {
                    theResult.addInstruction(new BytecodeInstructionGenericArrayLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.BYTE));
                    continue block212;
                }
                case 52: {
                    theResult.addInstruction(new BytecodeInstructionGenericArrayLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.CHAR));
                    continue block212;
                }
                case 53: {
                    theResult.addInstruction(new BytecodeInstructionGenericArrayLOAD(theOpcodeIndex, BytecodePrimitiveTypeRef.SHORT));
                    continue block212;
                }
                case 54: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionGenericSTORE(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress()), BytecodePrimitiveTypeRef.INT, theIndex));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.INT, theIndex));
                    continue block212;
                }
                case 55: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionGenericSTORE(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress() - 1), BytecodePrimitiveTypeRef.LONG, theIndex));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG, theIndex));
                    continue block212;
                }
                case 56: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionGenericSTORE(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress() - 1), BytecodePrimitiveTypeRef.FLOAT, theIndex));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT, theIndex));
                    continue block212;
                }
                case 57: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionGenericSTORE(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress() - 1), BytecodePrimitiveTypeRef.FLOAT, theIndex));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT, theIndex));
                    continue block212;
                }
                case 58: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionASTORE(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress() - 1), theIndex));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionASTORE(theOpcodeIndex, theIndex));
                    continue block212;
                }
                case 59: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.INT, 0));
                    continue block212;
                }
                case 60: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.INT, 1));
                    continue block212;
                }
                case 61: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.INT, 2));
                    continue block212;
                }
                case 62: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.INT, 3));
                    continue block212;
                }
                case 63: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG, 0));
                    continue block212;
                }
                case 64: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG, 1));
                    continue block212;
                }
                case 65: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG, 2));
                    continue block212;
                }
                case 66: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG, 3));
                    continue block212;
                }
                case 67: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT, 0));
                    continue block212;
                }
                case 68: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT, 1));
                    continue block212;
                }
                case 69: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT, 2));
                    continue block212;
                }
                case 70: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT, 3));
                    continue block212;
                }
                case 71: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE, 0));
                    continue block212;
                }
                case 72: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE, 1));
                    continue block212;
                }
                case 73: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE, 2));
                    continue block212;
                }
                case 74: {
                    theResult.addInstruction(new BytecodeInstructionGenericSTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE, 3));
                    continue block212;
                }
                case 75: {
                    theResult.addInstruction(new BytecodeInstructionASTORE(theOpcodeIndex, 0));
                    continue block212;
                }
                case 76: {
                    theResult.addInstruction(new BytecodeInstructionASTORE(theOpcodeIndex, 1));
                    continue block212;
                }
                case 77: {
                    theResult.addInstruction(new BytecodeInstructionASTORE(theOpcodeIndex, 2));
                    continue block212;
                }
                case 78: {
                    theResult.addInstruction(new BytecodeInstructionASTORE(theOpcodeIndex, 3));
                    continue block212;
                }
                case 79: {
                    theResult.addInstruction(new BytecodeInstructionGenericArraySTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 80: {
                    theResult.addInstruction(new BytecodeInstructionGenericArraySTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 81: {
                    theResult.addInstruction(new BytecodeInstructionGenericArraySTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 82: {
                    theResult.addInstruction(new BytecodeInstructionGenericArraySTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 83: {
                    theResult.addInstruction(new BytecodeInstructionObjectArraySTORE(theOpcodeIndex));
                    continue block212;
                }
                case 84: {
                    theResult.addInstruction(new BytecodeInstructionGenericArraySTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.BYTE));
                    continue block212;
                }
                case 85: {
                    theResult.addInstruction(new BytecodeInstructionGenericArraySTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.CHAR));
                    continue block212;
                }
                case 86: {
                    theResult.addInstruction(new BytecodeInstructionGenericArraySTORE(theOpcodeIndex, BytecodePrimitiveTypeRef.SHORT));
                    continue block212;
                }
                case 87: {
                    theResult.addInstruction(new BytecodeInstructionPOP(theOpcodeIndex));
                    continue block212;
                }
                case 88: {
                    theResult.addInstruction(new BytecodeInstructionPOP2(theOpcodeIndex));
                    continue block212;
                }
                case 89: {
                    theResult.addInstruction(new BytecodeInstructionDUP(theOpcodeIndex));
                    continue block212;
                }
                case 90: {
                    theResult.addInstruction(new BytecodeInstructionDUPX1(theOpcodeIndex));
                    continue block212;
                }
                case 91: {
                    theResult.addInstruction(new BytecodeInstructionDUPX2(theOpcodeIndex));
                    continue block212;
                }
                case 92: {
                    theResult.addInstruction(new BytecodeInstructionDUP2(theOpcodeIndex));
                    continue block212;
                }
                case 93: {
                    theResult.addInstruction(new BytecodeInstructionDUP2X1(theOpcodeIndex));
                    continue block212;
                }
                case 94: {
                    theResult.addInstruction(new BytecodeInstructionDUP2X2(theOpcodeIndex));
                    continue block212;
                }
                case 95: {
                    theResult.addInstruction(new BytecodeInstructionSWAP(theOpcodeIndex));
                    continue block212;
                }
                case 96: {
                    theResult.addInstruction(new BytecodeInstructionGenericADD(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 97: {
                    theResult.addInstruction(new BytecodeInstructionGenericADD(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 98: {
                    theResult.addInstruction(new BytecodeInstructionGenericADD(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 99: {
                    theResult.addInstruction(new BytecodeInstructionGenericADD(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 100: {
                    theResult.addInstruction(new BytecodeInstructionGenericSUB(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 101: {
                    theResult.addInstruction(new BytecodeInstructionGenericSUB(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 102: {
                    theResult.addInstruction(new BytecodeInstructionGenericSUB(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 103: {
                    theResult.addInstruction(new BytecodeInstructionGenericSUB(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 104: {
                    theResult.addInstruction(new BytecodeInstructionGenericMUL(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 105: {
                    theResult.addInstruction(new BytecodeInstructionGenericMUL(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 106: {
                    theResult.addInstruction(new BytecodeInstructionGenericMUL(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 107: {
                    theResult.addInstruction(new BytecodeInstructionGenericMUL(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 108: {
                    theResult.addInstruction(new BytecodeInstructionGenericDIV(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 109: {
                    theResult.addInstruction(new BytecodeInstructionGenericDIV(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 110: {
                    theResult.addInstruction(new BytecodeInstructionGenericDIV(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 111: {
                    theResult.addInstruction(new BytecodeInstructionGenericDIV(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 112: {
                    theResult.addInstruction(new BytecodeInstructionGenericREM(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 113: {
                    theResult.addInstruction(new BytecodeInstructionGenericREM(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 114: {
                    theResult.addInstruction(new BytecodeInstructionGenericREM(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 115: {
                    theResult.addInstruction(new BytecodeInstructionGenericREM(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 116: {
                    theResult.addInstruction(new BytecodeInstructionGenericNEG(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 117: {
                    theResult.addInstruction(new BytecodeInstructionGenericNEG(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 118: {
                    theResult.addInstruction(new BytecodeInstructionGenericNEG(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 119: {
                    theResult.addInstruction(new BytecodeInstructionGenericNEG(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 120: {
                    theResult.addInstruction(new BytecodeInstructionGenericSHL(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 121: {
                    theResult.addInstruction(new BytecodeInstructionGenericSHL(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 122: {
                    theResult.addInstruction(new BytecodeInstructionGenericSHR(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 123: {
                    theResult.addInstruction(new BytecodeInstructionGenericSHR(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 124: {
                    theResult.addInstruction(new BytecodeInstructionGenericUSHR(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 125: {
                    theResult.addInstruction(new BytecodeInstructionGenericUSHR(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 126: {
                    theResult.addInstruction(new BytecodeInstructionGenericAND(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 127: {
                    theResult.addInstruction(new BytecodeInstructionGenericAND(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 128: {
                    theResult.addInstruction(new BytecodeInstructionGenericOR(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 129: {
                    theResult.addInstruction(new BytecodeInstructionGenericOR(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 130: {
                    theResult.addInstruction(new BytecodeInstructionGenericXOR(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 131: {
                    theResult.addInstruction(new BytecodeInstructionGenericXOR(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 132: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        short theConstant = BytecodeParserUtils.signedShortFromByteArray(aBytecodes, offset += 2);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionIINC(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress() - 1), theIndex, theConstant));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    int theConstant = BytecodeParserUtils.signedByteFromByteArray(aBytecodes, ++offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionIINC(theOpcodeIndex, theIndex, theConstant));
                    continue block212;
                }
                case 133: {
                    theResult.addInstruction(new BytecodeInstructionI2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 134: {
                    theResult.addInstruction(new BytecodeInstructionI2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 135: {
                    theResult.addInstruction(new BytecodeInstructionI2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 136: {
                    theResult.addInstruction(new BytecodeInstructionL2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 137: {
                    theResult.addInstruction(new BytecodeInstructionL2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 138: {
                    theResult.addInstruction(new BytecodeInstructionL2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 139: {
                    theResult.addInstruction(new BytecodeInstructionF2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 140: {
                    theResult.addInstruction(new BytecodeInstructionF2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 141: {
                    theResult.addInstruction(new BytecodeInstructionF2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 142: {
                    theResult.addInstruction(new BytecodeInstructionD2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 143: {
                    theResult.addInstruction(new BytecodeInstructionD2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 144: {
                    theResult.addInstruction(new BytecodeInstructionD2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 145: {
                    theResult.addInstruction(new BytecodeInstructionI2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.BYTE));
                    continue block212;
                }
                case 146: {
                    theResult.addInstruction(new BytecodeInstructionI2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.CHAR));
                    continue block212;
                }
                case 147: {
                    theResult.addInstruction(new BytecodeInstructionI2Generic(theOpcodeIndex, BytecodePrimitiveTypeRef.SHORT));
                    continue block212;
                }
                case 148: {
                    theResult.addInstruction(new BytecodeInstructionLCMP(theOpcodeIndex));
                    continue block212;
                }
                case 149: {
                    theResult.addInstruction(new BytecodeInstructionGenericCMP(theOpcodeIndex, BytecodeInstructionGenericCMP.Type.l, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 150: {
                    theResult.addInstruction(new BytecodeInstructionGenericCMP(theOpcodeIndex, BytecodeInstructionGenericCMP.Type.g, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 151: {
                    theResult.addInstruction(new BytecodeInstructionGenericCMP(theOpcodeIndex, BytecodeInstructionGenericCMP.Type.l, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 152: {
                    theResult.addInstruction(new BytecodeInstructionGenericCMP(theOpcodeIndex, BytecodeInstructionGenericCMP.Type.g, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 153: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFCOND(theOpcodeIndex, BytecodeInstructionIFCOND.Type.eq, theIndex));
                    continue block212;
                }
                case 154: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFCOND(theOpcodeIndex, BytecodeInstructionIFCOND.Type.ne, theIndex));
                    continue block212;
                }
                case 155: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFCOND(theOpcodeIndex, BytecodeInstructionIFCOND.Type.lt, theIndex));
                    continue block212;
                }
                case 156: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFCOND(theOpcodeIndex, BytecodeInstructionIFCOND.Type.ge, theIndex));
                    continue block212;
                }
                case 157: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFCOND(theOpcodeIndex, BytecodeInstructionIFCOND.Type.gt, theIndex));
                    continue block212;
                }
                case 158: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFCOND(theOpcodeIndex, BytecodeInstructionIFCOND.Type.le, theIndex));
                    continue block212;
                }
                case 159: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFICMP(theOpcodeIndex, BytecodeInstructionIFICMP.Type.eq, theIndex));
                    continue block212;
                }
                case 160: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFICMP(theOpcodeIndex, BytecodeInstructionIFICMP.Type.ne, theIndex));
                    continue block212;
                }
                case 161: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFICMP(theOpcodeIndex, BytecodeInstructionIFICMP.Type.lt, theIndex));
                    continue block212;
                }
                case 162: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFICMP(theOpcodeIndex, BytecodeInstructionIFICMP.Type.ge, theIndex));
                    continue block212;
                }
                case 163: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFICMP(theOpcodeIndex, BytecodeInstructionIFICMP.Type.gt, theIndex));
                    continue block212;
                }
                case 164: {
                    int theOffset = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFICMP(theOpcodeIndex, BytecodeInstructionIFICMP.Type.le, theOffset));
                    continue block212;
                }
                case 165: {
                    int theOffset = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFACMP(theOpcodeIndex, BytecodeInstructionIFACMP.Type.eq, theOffset));
                    continue block212;
                }
                case 166: {
                    int theOffset = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFACMP(theOpcodeIndex, BytecodeInstructionIFACMP.Type.ne, theOffset));
                    continue block212;
                }
                case 167: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionGOTO(theOpcodeIndex, theIndex));
                    continue block212;
                }
                case 168: {
                    byte theBranchByte1 = aBytecodes[offset++];
                    byte theBranchByte2 = aBytecodes[offset++];
                    theResult.addInstruction(new BytecodeInstructionJSR(theOpcodeIndex, theBranchByte1, theBranchByte2));
                    continue block212;
                }
                case 169: {
                    int theIndex;
                    if (isWideOperator) {
                        theIndex = BytecodeParserUtils.shortFromByteArray(aBytecodes, offset);
                        offset += 2;
                        theResult.addInstruction(new BytecodeInstructionRET(new BytecodeOpcodeAddress(theOpcodeIndex.getAddress() - 1), theIndex));
                        continue block212;
                    }
                    theIndex = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    theResult.addInstruction(new BytecodeInstructionRET(theOpcodeIndex, theIndex));
                    continue block212;
                }
                case 170: {
                    int theRemainder = offset % 4;
                    if (theRemainder > 0) {
                        offset += 4 - theRemainder;
                    }
                    long theDefault = BytecodeParserUtils.longFromByteArray(aBytecodes, offset);
                    long theLow = BytecodeParserUtils.longFromByteArray(aBytecodes, offset += 4);
                    long theHigh = BytecodeParserUtils.longFromByteArray(aBytecodes, offset += 4);
                    offset += 4;
                    long theNumOffsets = theHigh - theLow + 1L;
                    long[] theOffsets = new long[(int)theNumOffsets];
                    int i = 0;
                    while ((long)i < theNumOffsets) {
                        long theOffset = BytecodeParserUtils.longFromByteArray(aBytecodes, offset);
                        offset += 4;
                        theOffsets[i] = theOffset;
                        ++i;
                    }
                    theResult.addInstruction(new BytecodeInstructionTABLESWITCH(theOpcodeIndex, theDefault, theLow, theHigh, theOffsets));
                    continue block212;
                }
                case 171: {
                    int theRemainder = offset % 4;
                    if (theRemainder > 0) {
                        offset += 4 - theRemainder;
                    }
                    long theDefault = BytecodeParserUtils.longFromByteArray(aBytecodes, offset);
                    long theNumPairs = BytecodeParserUtils.longFromByteArray(aBytecodes, offset += 4);
                    offset += 4;
                    BytecodeInstructionLOOKUPSWITCH.Pair[] thePairs = new BytecodeInstructionLOOKUPSWITCH.Pair[(int)theNumPairs];
                    for (long i = 0L; i < theNumPairs; ++i) {
                        long theMatch = BytecodeParserUtils.longFromByteArray(aBytecodes, offset);
                        long theOffset = BytecodeParserUtils.longFromByteArray(aBytecodes, offset += 4);
                        offset += 4;
                        thePairs[(int)i] = new BytecodeInstructionLOOKUPSWITCH.Pair(theMatch, theOffset);
                    }
                    theResult.addInstruction(new BytecodeInstructionLOOKUPSWITCH(theOpcodeIndex, theDefault, thePairs));
                    continue block212;
                }
                case 172: {
                    theResult.addInstruction(new BytecodeInstructionGenericRETURN(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                    continue block212;
                }
                case 173: {
                    theResult.addInstruction(new BytecodeInstructionGenericRETURN(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                    continue block212;
                }
                case 174: {
                    theResult.addInstruction(new BytecodeInstructionGenericRETURN(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                    continue block212;
                }
                case 175: {
                    theResult.addInstruction(new BytecodeInstructionGenericRETURN(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                    continue block212;
                }
                case 176: {
                    theResult.addInstruction(new BytecodeInstructionObjectRETURN(theOpcodeIndex));
                    continue block212;
                }
                case 177: {
                    theResult.addInstruction(new BytecodeInstructionRETURN(theOpcodeIndex));
                    continue block212;
                }
                case 178: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionGETSTATIC(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 179: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionPUTSTATIC(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 180: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionGETFIELD(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 181: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionPUTFIELD(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 182: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionINVOKEVIRTUAL(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 183: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionINVOKESPECIAL(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 184: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionINVOKESTATIC(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 185: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    int theCount = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset += 2);
                    int n = ++offset;
                    ++offset;
                    byte theNull = aBytecodes[n];
                    theResult.addInstruction(new BytecodeInstructionINVOKEINTERFACE(theOpcodeIndex, theIndex, theCount, aConstantPool));
                    continue block212;
                }
                case 186: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    byte theNull1 = aBytecodes[offset++];
                    byte theNull2 = aBytecodes[offset++];
                    theResult.addInstruction(new BytecodeInstructionINVOKEDYNAMIC(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 187: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionNEW(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 188: {
                    int theType = BytecodeParserUtils.byteFromByteArray(aBytecodes, offset);
                    ++offset;
                    switch (theType) {
                        case 4: {
                            theResult.addInstruction(new BytecodeInstructionNEWARRAY(theOpcodeIndex, BytecodePrimitiveTypeRef.BOOLEAN));
                            continue block212;
                        }
                        case 5: {
                            theResult.addInstruction(new BytecodeInstructionNEWARRAY(theOpcodeIndex, BytecodePrimitiveTypeRef.CHAR));
                            continue block212;
                        }
                        case 6: {
                            theResult.addInstruction(new BytecodeInstructionNEWARRAY(theOpcodeIndex, BytecodePrimitiveTypeRef.FLOAT));
                            continue block212;
                        }
                        case 7: {
                            theResult.addInstruction(new BytecodeInstructionNEWARRAY(theOpcodeIndex, BytecodePrimitiveTypeRef.DOUBLE));
                            continue block212;
                        }
                        case 8: {
                            theResult.addInstruction(new BytecodeInstructionNEWARRAY(theOpcodeIndex, BytecodePrimitiveTypeRef.BYTE));
                            continue block212;
                        }
                        case 9: {
                            theResult.addInstruction(new BytecodeInstructionNEWARRAY(theOpcodeIndex, BytecodePrimitiveTypeRef.SHORT));
                            continue block212;
                        }
                        case 10: {
                            theResult.addInstruction(new BytecodeInstructionNEWARRAY(theOpcodeIndex, BytecodePrimitiveTypeRef.INT));
                            continue block212;
                        }
                        case 11: {
                            theResult.addInstruction(new BytecodeInstructionNEWARRAY(theOpcodeIndex, BytecodePrimitiveTypeRef.LONG));
                            continue block212;
                        }
                    }
                    throw new IllegalStateException("Unknown array type : " + theType);
                }
                case 189: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionANEWARRAY(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 190: {
                    theResult.addInstruction(new BytecodeInstructionARRAYLENGTH(theOpcodeIndex));
                    continue block212;
                }
                case 191: {
                    theResult.addInstruction(new BytecodeInstructionATHROW(theOpcodeIndex));
                    continue block212;
                }
                case 192: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionCHECKCAST(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 193: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionINSTANCEOF(theOpcodeIndex, theIndex, aConstantPool));
                    continue block212;
                }
                case 194: {
                    theResult.addInstruction(new BytecodeInstructionMONITORENTER(theOpcodeIndex));
                    continue block212;
                }
                case 195: {
                    theResult.addInstruction(new BytecodeInstructionMONITOREXIT(theOpcodeIndex));
                    continue block212;
                }
                case 196: {
                    wide = true;
                    continue block212;
                }
                case 197: {
                    int theIndex = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    byte theDimensions = aBytecodes[offset++];
                    theResult.addInstruction(new BytecodeInstructionNEWMULTIARRAY(theOpcodeIndex, theIndex, theDimensions, aConstantPool));
                    continue block212;
                }
                case 198: {
                    int theOffset = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFNULL(theOpcodeIndex, theOffset));
                    continue block212;
                }
                case 199: {
                    int theOffset = BytecodeParserUtils.integerFromByteArray(aBytecodes, offset);
                    offset += 2;
                    theResult.addInstruction(new BytecodeInstructionIFNONNULL(theOpcodeIndex, theOffset));
                    continue block212;
                }
            }
            throw new IllegalStateException("Unknown opcode : " + theOpcode);
        }
        return theResult;
    }
}

