/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Function;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Const;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;

public class WeakFunctionTableReference
implements WASMValue {
    private final String functionName;
    private final Expression expression;

    WeakFunctionTableReference(String functionName, Expression expression) {
        this.functionName = functionName;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        Object f = context.functionIndex().firstByLabel(this.functionName);
        int theIndex = context.anyFuncTable().indexOf((Function)f);
        if (theIndex < 0) {
            throw new IllegalStateException("Cannot call function that is not part of the table : " + this.functionName);
        }
        textWriter.opening();
        textWriter.write("i32.const");
        textWriter.space();
        textWriter.writeInteger(theIndex);
        textWriter.closing();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        Object f = context.functionIndex().firstByLabel(this.functionName);
        int theIndex = context.anyFuncTable().indexOf((Function)f);
        if (theIndex < 0) {
            throw new IllegalStateException("Cannot call function that is not part of the table : " + this.functionName);
        }
        codeWriter.registerDebugInformationFor(this.expression);
        I32Const c = new I32Const(theIndex, this.expression);
        c.writeTo(codeWriter, context);
    }
}

