/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TypesSection;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class WASMType {
    private final TypesSection typesSection;
    private final List<PrimitiveType> parameter;
    private final PrimitiveType resultType;

    WASMType(TypesSection section, List<PrimitiveType> parameter, PrimitiveType resultType) {
        this.typesSection = section;
        this.parameter = parameter;
        this.resultType = resultType;
    }

    WASMType(TypesSection section, List<PrimitiveType> parameter) {
        this.typesSection = section;
        this.parameter = parameter;
        this.resultType = null;
    }

    WASMType(TypesSection section, PrimitiveType resultType) {
        this.typesSection = section;
        this.parameter = null;
        this.resultType = resultType;
    }

    public boolean matches(List<PrimitiveType> otherParameter, PrimitiveType otherResultType) {
        return Objects.equals(this.parameter, otherParameter) && Objects.equals((Object)this.resultType, (Object)otherResultType);
    }

    public boolean isVoid() {
        return this.resultType == null;
    }

    public PrimitiveType getResultType() {
        return this.resultType;
    }

    public void writeTo(TextWriter writer) {
        writer.opening();
        writer.write("type");
        writer.space();
        writer.write("$t");
        writer.write(Integer.toString(this.typesSection.indexOf(this)));
        writer.space();
        writer.opening();
        writer.write("func");
        if (null != this.parameter) {
            for (PrimitiveType param : this.parameter) {
                writer.space();
                writer.opening();
                writer.write("param");
                writer.space();
                param.writeTo(writer);
                writer.closing();
            }
        }
        if (null != this.resultType) {
            writer.space();
            writer.opening();
            writer.write("result");
            writer.space();
            this.resultType.writeTo(writer);
            writer.closing();
        }
        writer.closing();
        writer.closing();
    }

    public void writeRefTo(TextWriter writer) {
        writer.opening();
        writer.write("type");
        writer.space();
        writer.write("$t");
        writer.write(Integer.toString(this.typesSection.indexOf(this)));
        writer.closing();
    }

    public void writeTo(BinaryWriter.SectionWriter sectionWriter) throws IOException {
        sectionWriter.writeByte(PrimitiveType.func.getBinaryType());
        if (null != this.parameter) {
            sectionWriter.writeUnsignedLeb128(this.parameter.size());
            for (PrimitiveType type : this.parameter) {
                type.writeTo(sectionWriter);
            }
        } else {
            sectionWriter.writeUnsignedLeb128(0);
        }
        if (null != this.resultType) {
            sectionWriter.writeUnsignedLeb128(1);
            this.resultType.writeTo(sectionWriter);
        } else {
            sectionWriter.writeUnsignedLeb128(0);
        }
    }

    public int index() {
        return this.typesSection.indexOf(this);
    }
}

