/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Exportable;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TypesSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import java.io.IOException;

public class WASMEvent
implements Exportable {
    private final WASMType type;
    private final String label;
    private final TypesSection typesSection;

    protected WASMEvent(TypesSection typesSection, String label, WASMType type) {
        this.label = label;
        this.type = type;
        this.typesSection = typesSection;
    }

    public String getLabel() {
        return this.label;
    }

    public void writeTo(BinaryWriter.SectionWriter sectionWriter) throws IOException {
        sectionWriter.writeUnsignedLeb128(0);
        sectionWriter.writeUnsignedLeb128(this.typesSection.indexOf(this.type));
    }

    public void writeTo(TextWriter textWriter) throws IOException {
        textWriter.opening();
        textWriter.write("event");
        textWriter.space();
        textWriter.writeLabel(this.label);
        textWriter.space();
        this.type.writeRefTo(textWriter);
        textWriter.closing();
        textWriter.newLine();
    }

    @Override
    public void writeRefTo(TextWriter textWriter) throws IOException {
        textWriter.opening();
        textWriter.write("event");
        textWriter.space();
        textWriter.writeLabel(this.label);
        textWriter.closing();
    }
}

