/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.ModuleSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TypeIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TypesSection
extends ModuleSection {
    private final List<WASMType> types = new ArrayList<WASMType>();

    TypesSection(Module aModule) {
        super(aModule);
    }

    public WASMType typeFor(List<PrimitiveType> parameter, PrimitiveType resultType) {
        for (WASMType known : this.types) {
            if (!known.matches(parameter, resultType)) continue;
            return known;
        }
        WASMType type = new WASMType(this, parameter, resultType);
        this.types.add(type);
        return type;
    }

    public WASMType typeFor(List<PrimitiveType> parameter) {
        for (WASMType known : this.types) {
            if (!known.matches(parameter, null)) continue;
            return known;
        }
        WASMType type = new WASMType(this, parameter);
        this.types.add(type);
        return type;
    }

    public WASMType typeFor(PrimitiveType resultType) {
        for (WASMType known : this.types) {
            if (!known.matches(null, resultType)) continue;
            return known;
        }
        WASMType type = new WASMType(this, resultType);
        this.types.add(type);
        return type;
    }

    int indexOf(WASMType type) {
        return this.types.indexOf(type);
    }

    public void writeTo(TextWriter textWriter) {
        for (WASMType type : this.types) {
            type.writeTo(textWriter);
            textWriter.newLine();
        }
    }

    public void writeTo(BinaryWriter binaryWriter) throws IOException {
        try (BinaryWriter.SectionWriter writer = binaryWriter.typeSection();){
            writer.writeUnsignedLeb128(this.types.size());
            for (WASMType type : this.types) {
                type.writeTo(writer);
            }
        }
    }

    public TypeIndex typesIndex() {
        TypeIndex result = new TypeIndex();
        for (WASMType t : this.types) {
            result.add(t);
        }
        return result;
    }
}

