/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Catch;
import de.mirkosertic.bytecoder.backend.wasm.ast.Container;
import de.mirkosertic.bytecoder.backend.wasm.ast.LabeledContainer;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;

public class Try
extends LabeledContainer
implements WASMExpression {
    private final PrimitiveType blockType;
    public final Catch catchBlock;

    Try(Container parent, PrimitiveType blockType, String label, Expression expression) {
        super(parent, label, expression);
        this.blockType = blockType;
        this.catchBlock = new Catch(this);
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        textWriter.opening();
        textWriter.write("try");
        textWriter.space();
        textWriter.writeLabel(this.getLabel());
        if (this.blockType != null) {
            textWriter.space();
            textWriter.opening();
            textWriter.write("result");
            textWriter.space();
            this.blockType.writeTo(textWriter);
            textWriter.closing();
        }
        textWriter.newLine();
        for (WASMExpression e : this.getChildren()) {
            e.writeTo(textWriter, context.subWith(this));
        }
        this.catchBlock.writeTo(textWriter, context);
        textWriter.closing();
        textWriter.newLine();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)6);
        if (this.blockType != null) {
            this.blockType.writeTo(codeWriter);
        } else {
            PrimitiveType.empty_pseudo_block.writeTo(codeWriter);
        }
        for (WASMExpression e : this.getChildren()) {
            e.writeTo(codeWriter, context.subWith(this));
        }
        this.catchBlock.writeTo(codeWriter, context);
        codeWriter.writeByte((byte)11);
    }
}

