/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMEvent;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;
import java.util.List;

public class ThrowException
implements WASMExpression {
    private final WASMEvent exception;
    private final List<WASMValue> arguments;
    private final Expression expression;

    public ThrowException(WASMEvent exception, List<WASMValue> arguments, Expression expression) {
        this.exception = exception;
        this.arguments = arguments;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        textWriter.opening();
        textWriter.write("throw");
        textWriter.space();
        textWriter.writeLabel(this.exception.getLabel());
        for (WASMValue argument : this.arguments) {
            textWriter.space();
            argument.writeTo(textWriter, context);
        }
        textWriter.closing();
        textWriter.newLine();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        for (WASMValue value : this.arguments) {
            value.writeTo(codeWriter, context);
        }
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)8);
        codeWriter.writeSignedLeb128(context.eventIndex().indexOf(this.exception));
    }
}

