/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import java.io.PrintWriter;

public class TextWriter
implements AutoCloseable {
    private final PrintWriter pw;
    private int indent;

    public TextWriter(PrintWriter pw) {
        this.pw = pw;
        this.indent = 0;
    }

    public void opening() {
        this.pw.print("(");
        ++this.indent;
    }

    public void write(String value) {
        this.pw.print(value);
    }

    public void newLine() {
        this.pw.println();
        for (int i = 0; i < this.indent; ++i) {
            this.pw.print("    ");
        }
    }

    public void closing() {
        this.pw.print(")");
        --this.indent;
    }

    public void writeText(String text) {
        this.pw.print("\"");
        this.pw.print(text);
        this.pw.print("\"");
    }

    public void writeInteger(int value) {
        this.pw.print(value);
    }

    public void writeAttribute(String name, int value) {
        this.pw.print(name);
        this.pw.print("=");
        this.pw.print(value);
    }

    public void space() {
        this.pw.print(" ");
    }

    public void writeLabel(String label) {
        this.pw.print("$");
        this.pw.print(label);
    }

    public void writeFloat(float value) {
        this.pw.print(value);
    }

    @Override
    public void close() {
        this.pw.close();
    }
}

