/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Function;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.ModuleSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TablesSection
extends ModuleSection {
    private AnyFuncTable funcTable;

    TablesSection(Module aModule) {
        super(aModule);
    }

    public void writeTo(TextWriter textWriter) {
        if (this.funcTable != null) {
            this.funcTable.writeTo(textWriter);
        }
    }

    public void writeTo(BinaryWriter binaryWriter) throws IOException {
        try (BinaryWriter.SectionWriter writer = binaryWriter.tablesSection();){
            if (this.funcTable == null) {
                writer.writeUnsignedLeb128(0);
            } else {
                writer.writeUnsignedLeb128(1);
                this.funcTable.writeTo(writer);
            }
        }
    }

    public boolean hasFuncTable() {
        return this.funcTable != null;
    }

    public AnyFuncTable funcTable() {
        if (this.funcTable == null) {
            this.funcTable = new AnyFuncTable();
        }
        return this.funcTable;
    }

    public static class AnyFuncTable {
        private final List<Function> functions = new ArrayList<Function>();

        AnyFuncTable() {
        }

        public int index() {
            return 0;
        }

        List<Function> functions() {
            return this.functions;
        }

        void addToTable(Function function) {
            this.functions.add(function);
        }

        public void writeTo(BinaryWriter.SectionWriter writer) throws IOException {
            PrimitiveType.anyfunc.writeTo(writer);
            writer.writeByte((byte)0);
            writer.writeUnsignedLeb128(this.functions.size());
        }

        public void writeTo(TextWriter textWriter) {
            textWriter.opening();
            textWriter.write("table");
            textWriter.space();
            textWriter.writeInteger(this.functions.size());
            textWriter.space();
            textWriter.write("anyfunc");
            textWriter.closing();
            textWriter.newLine();
        }

        public int indexOf(Function function) {
            return this.functions.indexOf(function);
        }
    }
}

