/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Local;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;

public class SetLocal
implements WASMExpression {
    private final Local local;
    private final WASMValue value;
    private final Expression expression;

    SetLocal(Local local, WASMValue value, Expression expression) {
        this.local = local;
        this.value = value;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        textWriter.opening();
        textWriter.write("set_local");
        textWriter.space();
        textWriter.writeLabel(this.local.getLabel());
        if (this.value != null) {
            textWriter.space();
            this.value.writeTo(textWriter, context);
        }
        textWriter.closing();
        textWriter.newLine();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        if (this.value != null) {
            this.value.writeTo(codeWriter, context);
        }
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)33);
        codeWriter.writeUnsignedLeb128(context.localIndex().indexOf(this.local));
    }
}

