/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import java.io.IOException;

public enum PrimitiveType {
    i32("i32", 127),
    f32("f32", 125),
    i64("i64", 126),
    f64("f64", 124),
    anyfunc("anyfunc", 112),
    func("func", 96),
    empty_pseudo_block("pseudo", 64),
    anyref("anyref", 111),
    except_ref("except_ref", -24);

    private final String text;
    private final byte binaryType;

    private PrimitiveType(String text, byte binaryType) {
        this.text = text;
        this.binaryType = binaryType;
    }

    public void writeTo(TextWriter textWriter) {
        textWriter.write(this.text);
    }

    public void writeTo(BinaryWriter.Writer binaryWriter) throws IOException {
        binaryWriter.writeByte(this.binaryType);
    }

    public byte getBinaryType() {
        return this.binaryType;
    }
}

