/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.EventIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.ExportableFunction;
import de.mirkosertic.bytecoder.backend.wasm.ast.Function;
import de.mirkosertic.bytecoder.backend.wasm.ast.FunctionIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Local;
import de.mirkosertic.bytecoder.backend.wasm.ast.LocalIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.ModuleSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.Param;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMEvent;
import java.io.IOException;
import java.util.ArrayList;

public class NameSection
extends ModuleSection {
    public NameSection(Module module) {
        super(module);
    }

    public void writeCodeTo(BinaryWriter writer) throws IOException {
        block71: {
            try (BinaryWriter.SectionWriter sectionWriter = writer.customSection();){
                Object f;
                int i;
                FunctionIndex functions2;
                sectionWriter.writeUTF8("name");
                try (BinaryWriter.SectionWriter moduleSection = sectionWriter.subSection((byte)0);){
                    moduleSection.writeUTF8(this.getModule().getLabel());
                }
                var5_7 = null;
                try (BinaryWriter.SectionWriter functionSection = sectionWriter.subSection((byte)1);){
                    functions2 = this.getModule().functionIndex();
                    functionSection.writeUnsignedLeb128(functions2.size());
                    for (i = 0; i < functions2.size(); ++i) {
                        f = functions2.get(i);
                        functionSection.writeUnsignedLeb128(i);
                        functionSection.writeUTF8(((Function)f).getLabel());
                    }
                }
                catch (Throwable functions2) {
                    var5_7 = functions2;
                    throw functions2;
                }
                var5_7 = null;
                try (BinaryWriter.SectionWriter localSection = sectionWriter.subSection((byte)2);){
                    functions2 = this.getModule().functionIndex();
                    localSection.writeUnsignedLeb128(functions2.size());
                    for (i = 0; i < functions2.size(); ++i) {
                        f = functions2.get(i);
                        localSection.writeUnsignedLeb128(i);
                        ArrayList<String> labels = new ArrayList<String>();
                        if (((Function)f).getParams() != null) {
                            for (Param p : ((Function)f).getParams()) {
                                labels.add(p.getLabel());
                            }
                        }
                        if (f instanceof ExportableFunction) {
                            ExportableFunction ef = (ExportableFunction)f;
                            LocalIndex localIndex = ef.localIndex();
                            for (Local l : localIndex.localsExcludingParams()) {
                                labels.add(l.getLabel());
                            }
                        }
                        localSection.writeUnsignedLeb128(labels.size());
                        for (int j = 0; j < labels.size(); ++j) {
                            localSection.writeUnsignedLeb128(j);
                            localSection.writeUTF8((String)labels.get(j));
                        }
                    }
                }
                catch (Throwable throwable) {
                    var5_7 = throwable;
                    throw throwable;
                }
                EventIndex eventIndex = this.getModule().eventIndex();
                if (eventIndex.isEmpty()) break block71;
                try (BinaryWriter.SectionWriter functionSection = sectionWriter.subSection((byte)3);){
                    functionSection.writeUnsignedLeb128(eventIndex.size());
                    for (i = 0; i < eventIndex.size(); ++i) {
                        f = eventIndex.get(i);
                        functionSection.writeUnsignedLeb128(i);
                        functionSection.writeUTF8(((WASMEvent)f).getLabel());
                    }
                }
            }
        }
    }
}

