/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.DataSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.ElementSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.EventIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.EventSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.ExportsSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.FunctionIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.FunctionsSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.GlobalsIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.GlobalsSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.ImportsSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.Memory;
import de.mirkosertic.bytecoder.backend.wasm.ast.MemorySection;
import de.mirkosertic.bytecoder.backend.wasm.ast.NameSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.SourceMapSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.StartSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.TablesSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TypesSection;
import java.io.IOException;
import java.util.ArrayList;

public class Module {
    private final String label;
    private final TypesSection types;
    private final FunctionsSection functions;
    private final TablesSection tables;
    private final MemorySection mems;
    private final GlobalsSection globals;
    private final ElementSection elements;
    private final ImportsSection imports;
    private final ExportsSection exports;
    private final NameSection names;
    private final EventSection events;
    private final SourceMapSection sourceMapSection;

    public Module(String label, String sourcemapFileName) {
        this.label = label;
        this.types = new TypesSection(this);
        this.exports = new ExportsSection(this);
        this.tables = new TablesSection(this);
        this.globals = new GlobalsSection(this);
        this.functions = new FunctionsSection(this);
        this.mems = new MemorySection(this);
        this.elements = new ElementSection(this);
        DataSection data = new DataSection(this);
        StartSection start = new StartSection(this);
        this.imports = new ImportsSection(this);
        this.names = new NameSection(this);
        this.events = new EventSection(this);
        this.sourceMapSection = new SourceMapSection(this, sourcemapFileName);
    }

    public void writeTo(TextWriter writer, boolean enableDebug) throws IOException {
        writer.opening();
        writer.write("module");
        writer.space();
        writer.writeLabel(this.label);
        writer.newLine();
        this.types.writeTo(writer);
        this.imports.writeTo(writer);
        this.mems.writeTo(writer);
        this.globals.writeTo(writer);
        this.events.writeCodeTo(writer);
        this.tables.writeTo(writer);
        this.elements.writeTo(writer);
        this.functions.writeTo(writer);
        this.exports.writeTo(writer);
        writer.closing();
    }

    public TypesSection getTypes() {
        return this.types;
    }

    public GlobalsIndex globalsIndex() {
        return this.globals.globalsIndex();
    }

    public EventIndex eventIndex() {
        return this.events.eventIndex();
    }

    public FunctionIndex functionIndex() {
        FunctionIndex functionIndex = new FunctionIndex();
        this.imports.addFunctionsToIndex(functionIndex);
        this.functions.addFunctionsToIndex(functionIndex);
        return functionIndex;
    }

    public void writeTo(BinaryWriter writer, boolean enableDebug) throws IOException {
        FunctionIndex functionIndex = this.functionIndex();
        ArrayList<Memory> memoryIndex = new ArrayList<Memory>();
        this.mems.addMemoriesToIndex(memoryIndex);
        writer.header();
        this.types.writeTo(writer);
        this.imports.writeTo(writer, memoryIndex);
        this.functions.writeTo(writer, functionIndex);
        this.tables.writeTo(writer);
        this.mems.writeTo(writer);
        this.globals.writeTo(writer);
        this.events.writeCodeTo(writer);
        this.exports.writeTo(writer, memoryIndex);
        this.elements.writeTo(writer, functionIndex);
        this.functions.writeCodeTo(writer, functionIndex);
        if (enableDebug) {
            this.names.writeCodeTo(writer);
        }
        this.sourceMapSection.writeTo(writer);
    }

    public String getLabel() {
        return this.label;
    }

    public MemorySection getMems() {
        return this.mems;
    }

    public FunctionsSection getFunctions() {
        return this.functions;
    }

    public ImportsSection getImports() {
        return this.imports;
    }

    public GlobalsSection getGlobals() {
        return this.globals;
    }

    public ExportsSection getExports() {
        return this.exports;
    }

    public TablesSection getTables() {
        return this.tables;
    }

    public EventSection getEvents() {
        return this.events;
    }
}

