/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Memory;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.ModuleSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MemorySection
extends ModuleSection {
    private final List<Memory> memories = new ArrayList<Memory>();

    MemorySection(Module aModule) {
        super(aModule);
    }

    public Memory newMemory(int initialPages, int maximumPages) {
        Memory memory = new Memory(this, initialPages, maximumPages);
        this.memories.add(memory);
        return memory;
    }

    int indexOf(Memory memory) {
        return this.memories.indexOf(memory);
    }

    void export(Memory memory, String objectName) {
        this.getModule().getExports().export(memory, objectName);
    }

    public void writeTo(TextWriter textWriter) {
        for (Memory memory : this.memories) {
            memory.writeTo(textWriter);
            textWriter.newLine();
        }
    }

    public void writeTo(BinaryWriter binaryWriter) throws IOException {
        try (BinaryWriter.SectionWriter writer = binaryWriter.memorySection();){
            writer.writeUnsignedLeb128(this.memories.size());
            for (Memory memory : this.memories) {
                memory.writeTo(writer);
            }
        }
    }

    public void addMemoriesToIndex(List<Memory> memoryIndex) {
        memoryIndex.addAll(this.memories);
    }
}

