/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Exportable;
import de.mirkosertic.bytecoder.backend.wasm.ast.MemorySection;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import java.io.IOException;

public class Memory
implements Exportable {
    private final MemorySection memory;
    private final int initialPages;
    private final int maximumPages;

    Memory(MemorySection content, int initialPages, int maximumPages) {
        this.memory = content;
        this.initialPages = initialPages;
        this.maximumPages = maximumPages;
    }

    public void exportAs(String objectName) {
        this.memory.export(this, objectName);
    }

    public void writeTo(TextWriter textWriter) {
        textWriter.opening();
        textWriter.write("memory");
        textWriter.space();
        textWriter.writeLabel("mem" + this.memory.indexOf(this));
        textWriter.space();
        textWriter.writeInteger(this.initialPages);
        textWriter.space();
        textWriter.writeInteger(this.maximumPages);
        textWriter.closing();
    }

    @Override
    public void writeRefTo(TextWriter textWriter) {
        textWriter.opening();
        textWriter.write("memory");
        textWriter.space();
        textWriter.writeLabel("mem" + this.memory.indexOf(this));
        textWriter.closing();
    }

    public void writeTo(BinaryWriter.Writer writer) throws IOException {
        writer.writeByte((byte)1);
        writer.writeUnsignedLeb128(this.initialPages);
        writer.writeUnsignedLeb128(this.maximumPages);
    }
}

