/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Container;
import de.mirkosertic.bytecoder.backend.wasm.ast.LabeledContainer;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;

public class Loop
extends LabeledContainer
implements WASMExpression {
    Loop(String label, Container parent, Expression expression) {
        super(parent, label, expression);
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        textWriter.opening();
        textWriter.write("loop");
        textWriter.space();
        textWriter.writeLabel(this.getLabel());
        if (this.hasChildren()) {
            textWriter.newLine();
            for (WASMValue wASMValue : this.getChildren()) {
                wASMValue.writeTo(textWriter, context);
            }
            textWriter.closing();
        } else {
            textWriter.closing();
        }
        textWriter.newLine();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)3);
        PrimitiveType.empty_pseudo_block.writeTo(codeWriter);
        for (WASMExpression e : this.getChildren()) {
            e.writeTo(codeWriter, context.subWith(this));
        }
        codeWriter.writeByte((byte)11);
    }
}

