/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.EventIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Function;
import de.mirkosertic.bytecoder.backend.wasm.ast.FunctionIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.ImportReference;
import de.mirkosertic.bytecoder.backend.wasm.ast.Importable;
import de.mirkosertic.bytecoder.backend.wasm.ast.Local;
import de.mirkosertic.bytecoder.backend.wasm.ast.Memory;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.ModuleSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.Param;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMEvent;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ImportsSection
extends ModuleSection {
    private final List<ImportEntry> imports = new ArrayList<ImportEntry>();

    ImportsSection(Module aModule) {
        super(aModule);
    }

    public Function importFunction(ImportReference importReference, String label, List<Param> parameter, PrimitiveType result) {
        WASMType type = this.getModule().getTypes().typeFor(parameter.stream().map(Local::getType).collect(Collectors.toList()), result);
        Function function = new Function(this.getModule(), type, label, parameter, result);
        this.imports.add(new ImportEntry(importReference, function));
        return function;
    }

    public Function importFunction(ImportReference importReference, String label, List<Param> parameter) {
        WASMType type = this.getModule().getTypes().typeFor(parameter.stream().map(Local::getType).collect(Collectors.toList()));
        Function function = new Function(this.getModule(), type, label, parameter);
        this.imports.add(new ImportEntry(importReference, function));
        return function;
    }

    public Function importFunction(ImportReference importReference, String label, PrimitiveType result) {
        WASMType type = this.getModule().getTypes().typeFor(result);
        Function function = new Function(this.getModule(), type, label, result);
        this.imports.add(new ImportEntry(importReference, function));
        return function;
    }

    public void writeTo(TextWriter textWriter) throws IOException {
        for (ImportEntry entry : this.imports) {
            ImportReference ref = entry.getReference();
            textWriter.opening();
            textWriter.write("import");
            textWriter.space();
            textWriter.writeText(ref.getModuleName());
            textWriter.space();
            textWriter.writeText(ref.getObjectName());
            textWriter.space();
            entry.getImportable().writeTo(textWriter, this.getModule());
            textWriter.closing();
            textWriter.newLine();
        }
    }

    public void addFunctionsToIndex(FunctionIndex functionIndex) {
        for (ImportEntry value : this.imports) {
            if (!(value.getImportable() instanceof Function)) continue;
            functionIndex.add((Function)value.getImportable());
        }
    }

    public void writeTo(BinaryWriter binaryWriter, List<Memory> memoryIndex) throws IOException {
        EventIndex exceptionIndex = this.getModule().eventIndex();
        try (BinaryWriter.SectionWriter sectionWriter = binaryWriter.importsSection();){
            sectionWriter.writeUnsignedLeb128(this.imports.size());
            for (ImportEntry entry : this.imports) {
                Importable value = entry.getImportable();
                ImportReference ref = entry.getReference();
                sectionWriter.writeUTF8(ref.getModuleName());
                sectionWriter.writeUTF8(ref.getObjectName());
                if (value instanceof Function) {
                    sectionWriter.writeByte((byte)0);
                    Function f = (Function)value;
                    sectionWriter.writeUnsignedLeb128(this.getModule().getTypes().indexOf(f.getFunctionType()));
                    continue;
                }
                if (value instanceof Memory) {
                    sectionWriter.writeByte((byte)2);
                    sectionWriter.writeUnsignedLeb128(memoryIndex.indexOf((Memory)((Object)value)));
                    continue;
                }
                if (value instanceof WASMEvent) {
                    sectionWriter.writeByte((byte)4);
                    sectionWriter.writeUnsignedLeb128(exceptionIndex.indexOf((WASMEvent)((Object)value)));
                    continue;
                }
                throw new IllegalStateException("Not Implemented yet for " + value);
            }
        }
    }

    private static class ImportEntry {
        private final ImportReference reference;
        private final Importable importable;

        ImportEntry(ImportReference reference, Importable importable) {
            this.reference = reference;
            this.importable = importable;
        }

        ImportReference getReference() {
            return this.reference;
        }

        Importable getImportable() {
            return this.importable;
        }
    }
}

