/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Container;
import de.mirkosertic.bytecoder.backend.wasm.ast.Expressions;
import de.mirkosertic.bytecoder.backend.wasm.ast.LabeledContainer;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Iff
extends LabeledContainer
implements WASMExpression {
    public final Expressions falseFlow;
    private final WASMValue condition;
    private final List<WASMExpression> falseChildren;

    Iff(Container parent, String label, WASMValue condition, Expression expression) {
        super(parent, label, expression);
        this.condition = condition;
        this.falseChildren = new ArrayList<WASMExpression>();
        this.falseFlow = new Expressions(new Container(){

            @Override
            public boolean hasChildren() {
                return !Iff.this.falseChildren.isEmpty();
            }

            @Override
            public List<WASMExpression> getChildren() {
                return Iff.this.falseChildren;
            }

            @Override
            public void addChild(WASMExpression e) {
                Iff.this.falseChildren.add(e);
            }

            @Override
            public int relativeDepthTo(LabeledContainer outerBlock) {
                return Iff.super.relativeDepthTo(outerBlock);
            }

            @Override
            public int relativeDepthTo(LabeledContainer outerBlock, int offset) {
                return Iff.super.relativeDepthTo(outerBlock, offset);
            }

            @Override
            public LabeledContainer findByLabelInHierarchy(String aLabel) {
                return Iff.super.findByLabelInHierarchy(aLabel);
            }
        });
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        textWriter.opening();
        textWriter.write("if");
        textWriter.space();
        textWriter.writeLabel(this.getLabel());
        textWriter.space();
        this.condition.writeTo(textWriter, context);
        textWriter.newLine();
        textWriter.opening();
        textWriter.write("then");
        textWriter.newLine();
        if (this.hasChildren()) {
            for (WASMValue wASMValue : this.getChildren()) {
                wASMValue.writeTo(textWriter, context);
            }
            textWriter.closing();
        } else {
            textWriter.closing();
        }
        if (!this.falseChildren.isEmpty()) {
            textWriter.opening();
            textWriter.write("else");
            textWriter.newLine();
            for (WASMValue wASMValue : this.falseChildren) {
                wASMValue.writeTo(textWriter, context);
            }
            textWriter.closing();
        }
        textWriter.closing();
        textWriter.newLine();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        this.condition.writeTo(codeWriter, context);
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)4);
        PrimitiveType.empty_pseudo_block.writeTo(codeWriter);
        for (WASMExpression e : this.getChildren()) {
            e.writeTo(codeWriter, context.subWith(this));
        }
        if (!this.falseChildren.isEmpty()) {
            codeWriter.writeByte((byte)5);
            for (WASMExpression e : this.falseChildren) {
                e.writeTo(codeWriter, context.subWith(this));
            }
        }
        codeWriter.writeByte((byte)11);
    }
}

