/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.Alignment;
import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;

public class I32Load16U
implements WASMExpression {
    private final Alignment alignment;
    private final int offset;
    private final WASMValue ptr;
    private final Expression expression;

    I32Load16U(int offset, WASMValue ptr, Expression expression) {
        this(Alignment.TWO, offset, ptr, expression);
    }

    I32Load16U(Alignment alignment, int offset, WASMValue ptr, Expression expression) {
        this.alignment = alignment;
        this.offset = offset;
        this.ptr = ptr;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        textWriter.opening();
        textWriter.write("i32.load16_u");
        textWriter.space();
        textWriter.writeAttribute("offset", this.offset);
        textWriter.space();
        textWriter.writeAttribute("align", this.alignment.value());
        textWriter.space();
        this.ptr.writeTo(textWriter, context);
        textWriter.closing();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        this.ptr.writeTo(codeWriter, context);
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)47);
        codeWriter.writeUnsignedLeb128(this.alignment.log2Value());
        codeWriter.writeUnsignedLeb128(this.offset);
    }
}

