/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Global;
import de.mirkosertic.bytecoder.backend.wasm.ast.GlobalsIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.ModuleSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GlobalsSection
extends ModuleSection {
    private final List<Global> globals = new ArrayList<Global>();

    GlobalsSection(Module aModule) {
        super(aModule);
    }

    public Global newMutableGlobal(String name, PrimitiveType type, WASMValue initializer) {
        Global global = new Global(this.getModule().getExports(), name, type, true, initializer);
        this.globals.add(global);
        return global;
    }

    public Global newConstantGlobal(String name, PrimitiveType type, WASMValue initializer) {
        Global global = new Global(this.getModule().getExports(), name, type, false, initializer);
        this.globals.add(global);
        return global;
    }

    public void writeTo(TextWriter textWriter) throws IOException {
        for (Global global : this.globals) {
            global.writeTo(textWriter);
        }
    }

    public void writeTo(BinaryWriter binaryWriter) throws IOException {
        try (BinaryWriter.SectionWriter writer = binaryWriter.globalsSection();){
            writer.writeUnsignedLeb128(this.globals.size());
            for (Global global : this.globals) {
                global.writeTo(writer, this.globals);
            }
        }
    }

    public GlobalsIndex globalsIndex() {
        GlobalsIndex index = new GlobalsIndex();
        for (Global g : this.globals) {
            index.add(g);
        }
        return index;
    }
}

