/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.ExportsSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import java.io.IOException;
import java.util.List;

public class Global {
    private final ExportsSection exportsSection;
    private final String label;
    private final PrimitiveType type;
    private final boolean mutable;
    private final WASMValue initializer;

    Global(ExportsSection exportsSection, String name, PrimitiveType type, boolean mutable, WASMValue initializer) {
        this.exportsSection = exportsSection;
        this.label = name;
        this.type = type;
        this.mutable = mutable;
        this.initializer = initializer;
    }

    public String getLabel() {
        return this.label;
    }

    public PrimitiveType getType() {
        return this.type;
    }

    public void writeTo(TextWriter textWriter) throws IOException {
        textWriter.opening();
        textWriter.write("global");
        textWriter.space();
        textWriter.writeLabel(this.label);
        textWriter.space();
        if (this.mutable) {
            textWriter.opening();
            textWriter.write("mut");
            textWriter.space();
            this.type.writeTo(textWriter);
            textWriter.closing();
        } else {
            this.type.writeTo(textWriter);
        }
        textWriter.space();
        this.initializer.writeTo(textWriter, null);
        textWriter.closing();
        textWriter.newLine();
    }

    public void writeTo(BinaryWriter.SectionWriter writer, List<Global> globalIndex) throws IOException {
        this.type.writeTo(writer);
        if (this.mutable) {
            writer.writeByte((byte)1);
        } else {
            writer.writeByte((byte)0);
        }
        this.initializer.writeTo(writer, null);
        writer.writeByte((byte)11);
    }
}

