/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Local;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;

public class GetLocal
implements WASMExpression {
    private final Local local;
    private final Expression expression;

    GetLocal(Local local, Expression expression) {
        this.local = local;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) {
        textWriter.opening();
        textWriter.write("get_local");
        textWriter.space();
        textWriter.writeLabel(this.local.getLabel());
        textWriter.closing();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)32);
        codeWriter.writeUnsignedLeb128(context.localIndex().indexOf(this.local));
    }
}

