/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.ExportableFunction;
import de.mirkosertic.bytecoder.backend.wasm.ast.Function;
import de.mirkosertic.bytecoder.backend.wasm.ast.FunctionIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Local;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.ModuleSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.Param;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FunctionsSection
extends ModuleSection {
    private final List<ExportableFunction> functions = new ArrayList<ExportableFunction>();

    FunctionsSection(Module aModule) {
        super(aModule);
    }

    public ExportableFunction newFunction(String label, List<Param> parameter, PrimitiveType result) {
        WASMType type = this.getModule().getTypes().typeFor(parameter.stream().map(Local::getType).collect(Collectors.toList()), result);
        ExportableFunction function = new ExportableFunction(this.getModule(), type, label, parameter, result);
        this.functions.add(function);
        return function;
    }

    public ExportableFunction newFunction(String label, List<Param> parameter) {
        WASMType type = this.getModule().getTypes().typeFor(parameter.stream().map(Local::getType).collect(Collectors.toList()));
        ExportableFunction function = new ExportableFunction(this.getModule(), type, label, parameter);
        this.functions.add(function);
        return function;
    }

    public ExportableFunction newFunction(String label, PrimitiveType result) {
        WASMType type = this.getModule().getTypes().typeFor(result);
        ExportableFunction function = new ExportableFunction(this.getModule(), type, label, result);
        this.functions.add(function);
        return function;
    }

    public void writeTo(TextWriter textWriter) throws IOException {
        for (Function function : this.functions) {
            function.writeTo(textWriter, this.getModule());
            textWriter.newLine();
        }
    }

    public void writeTo(BinaryWriter binaryWriter, FunctionIndex functionIndex) throws IOException {
        try (BinaryWriter.SectionWriter sectionWriter = binaryWriter.functionSection();){
            List<ExportableFunction> exportableFunction = functionIndex.exportableFunctions();
            sectionWriter.writeUnsignedLeb128(exportableFunction.size());
            for (ExportableFunction function : exportableFunction) {
                sectionWriter.writeUnsignedLeb128(function.getFunctionType().index());
            }
        }
    }

    public void writeCodeTo(BinaryWriter binaryWriter, FunctionIndex functionIndex) throws IOException {
        try (BinaryWriter.SectionWriter sectionWriter = binaryWriter.codeSection();){
            List<ExportableFunction> functions = functionIndex.exportableFunctions();
            sectionWriter.writeUnsignedLeb128(functions.size());
            for (ExportableFunction function : functions) {
                function.writeCodeTo(sectionWriter, functionIndex);
            }
        }
    }

    public void addFunctionsToIndex(FunctionIndex functionIndex) {
        for (Function function : this.functions) {
            functionIndex.add(function);
        }
    }
}

