/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.ExportableFunction;
import de.mirkosertic.bytecoder.backend.wasm.ast.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FunctionIndex {
    private final List<Function> functions = new ArrayList<Function>();

    FunctionIndex() {
    }

    public int size() {
        return this.functions.size();
    }

    public Function get(int aIndex) {
        return this.functions.get(aIndex);
    }

    public void add(Function function) {
        this.functions.add(function);
    }

    public int indexOf(Function value) {
        return this.functions.indexOf(value);
    }

    public List<ExportableFunction> exportableFunctions() {
        return this.functions.stream().filter(t -> t instanceof ExportableFunction).map(t -> (ExportableFunction)t).collect(Collectors.toList());
    }

    public <T extends Function> T firstByLabel(String label) {
        for (Function function : this.functions) {
            if (!label.equalsIgnoreCase(function.getLabel())) continue;
            return (T)function;
        }
        throw new IllegalArgumentException("No such method : " + label);
    }

    public boolean hasFunction(String label) {
        for (Function function : this.functions) {
            if (!label.equalsIgnoreCase(function.getLabel())) continue;
            return true;
        }
        return false;
    }
}

