/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.Callable;
import de.mirkosertic.bytecoder.backend.wasm.ast.Container;
import de.mirkosertic.bytecoder.backend.wasm.ast.Importable;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.Param;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import java.io.IOException;
import java.util.List;

public class Function
extends Container
implements Importable,
Callable {
    private final Module module;
    private final WASMType functionType;
    private final String label;
    private final List<Param> params;
    private final PrimitiveType resultType;

    Function(Module aModule, WASMType functionType, String label, List<Param> params, PrimitiveType result) {
        this.module = aModule;
        this.functionType = functionType;
        this.label = label;
        this.params = params;
        this.resultType = result;
    }

    Function(Module aModule, WASMType functionType, String label, List<Param> params) {
        this.module = aModule;
        this.functionType = functionType;
        this.label = label;
        this.params = params;
        this.resultType = null;
    }

    Function(Module aModule, WASMType functionType, String label, PrimitiveType result) {
        this.module = aModule;
        this.functionType = functionType;
        this.label = label;
        this.params = null;
        this.resultType = result;
    }

    @Override
    public void writeTo(TextWriter textWriter, Module aModule) throws IOException {
        textWriter.opening();
        textWriter.write("func");
        textWriter.space();
        textWriter.writeLabel(this.label);
        textWriter.space();
        this.functionType.writeRefTo(textWriter);
        textWriter.closing();
    }

    protected Module getModule() {
        return this.module;
    }

    public WASMType getFunctionType() {
        return this.functionType;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public PrimitiveType getResultType() {
        return this.resultType;
    }

    public Function toTable() {
        this.module.getTables().funcTable().addToTable(this);
        return this;
    }

    @Override
    public PrimitiveType resolveResultType(WASMValue.ExportContext context) {
        return this.resultType;
    }

    @Override
    public int resolveIndex(WASMValue.ExportContext context) {
        return context.functionIndex().indexOf(this);
    }
}

