/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.Alignment;
import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;

public class F32Store
implements WASMExpression {
    private final Alignment alignment;
    private final int offset;
    private final WASMValue ptr;
    private final WASMValue value;
    private final Expression expression;

    F32Store(int offset, WASMValue ptr, WASMValue value, Expression expression) {
        this(Alignment.FOUR, offset, ptr, value, expression);
    }

    F32Store(Alignment alignment, int offset, WASMValue ptr, WASMValue value, Expression expression) {
        this.alignment = alignment;
        this.offset = offset;
        this.ptr = ptr;
        this.value = value;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        textWriter.opening();
        textWriter.write("f32.store");
        textWriter.space();
        textWriter.writeAttribute("offset", this.offset);
        textWriter.space();
        textWriter.writeAttribute("align", this.alignment.value());
        textWriter.space();
        this.ptr.writeTo(textWriter, context);
        textWriter.space();
        this.value.writeTo(textWriter, context);
        textWriter.closing();
        textWriter.newLine();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        this.ptr.writeTo(codeWriter, context);
        this.value.writeTo(codeWriter, context);
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)56);
        codeWriter.writeUnsignedLeb128(this.alignment.log2Value());
        codeWriter.writeUnsignedLeb128(this.offset);
    }
}

