/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;

public class F32Const
implements WASMValue {
    private final float value;
    private final Expression expression;

    F32Const(float value, Expression expression) {
        this.value = value;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) {
        textWriter.opening();
        textWriter.write("f32.const");
        textWriter.space();
        if (Float.isNaN(this.value)) {
            textWriter.write("nan");
        } else if (Float.isInfinite(this.value)) {
            textWriter.write("inf");
        } else {
            textWriter.writeFloat(this.value);
        }
        textWriter.closing();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) {
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)67);
        codeWriter.writeFloat32(this.value);
    }
}

