/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.Alignment;
import de.mirkosertic.bytecoder.backend.wasm.ast.Block;
import de.mirkosertic.bytecoder.backend.wasm.ast.Branch;
import de.mirkosertic.bytecoder.backend.wasm.ast.BranchIff;
import de.mirkosertic.bytecoder.backend.wasm.ast.BranchOnException;
import de.mirkosertic.bytecoder.backend.wasm.ast.Call;
import de.mirkosertic.bytecoder.backend.wasm.ast.CallIndirect;
import de.mirkosertic.bytecoder.backend.wasm.ast.Callable;
import de.mirkosertic.bytecoder.backend.wasm.ast.Container;
import de.mirkosertic.bytecoder.backend.wasm.ast.Drop;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Store;
import de.mirkosertic.bytecoder.backend.wasm.ast.Global;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Store;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Store16;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Store8;
import de.mirkosertic.bytecoder.backend.wasm.ast.Iff;
import de.mirkosertic.bytecoder.backend.wasm.ast.LabeledContainer;
import de.mirkosertic.bytecoder.backend.wasm.ast.Local;
import de.mirkosertic.bytecoder.backend.wasm.ast.Loop;
import de.mirkosertic.bytecoder.backend.wasm.ast.Nop;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.RethrowException;
import de.mirkosertic.bytecoder.backend.wasm.ast.Return;
import de.mirkosertic.bytecoder.backend.wasm.ast.ReturnValue;
import de.mirkosertic.bytecoder.backend.wasm.ast.SetGlobal;
import de.mirkosertic.bytecoder.backend.wasm.ast.SetLocal;
import de.mirkosertic.bytecoder.backend.wasm.ast.ThrowException;
import de.mirkosertic.bytecoder.backend.wasm.ast.Try;
import de.mirkosertic.bytecoder.backend.wasm.ast.Unreachable;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMEvent;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.util.List;

public class Expressions {
    private final Container parent;
    public final I32 i32;
    public final F32 f32;

    Expressions(Container parent) {
        this.parent = parent;
        this.i32 = new I32();
        this.f32 = new F32();
    }

    public void voidCall(Callable function, List<WASMValue> arguments, Expression expression) {
        Call call = new Call(function, arguments, expression);
        this.parent.addChild(call);
    }

    public void voidCallIndirect(WASMType functionType, List<WASMValue> arguments, WASMValue tableIndex, Expression expression) {
        CallIndirect call = new CallIndirect(functionType, arguments, tableIndex, expression);
        this.parent.addChild(call);
    }

    public Iff iff(String label, WASMValue condition, Expression expression) {
        Iff elem = new Iff(this.parent, label, condition, expression);
        this.parent.addChild(elem);
        return elem;
    }

    public Block block(String label, Expression expression) {
        Block block = new Block(label, this.parent, expression, PrimitiveType.empty_pseudo_block);
        this.parent.addChild(block);
        return block;
    }

    public Block block(String label, PrimitiveType blockType, Expression expression) {
        Block block = new Block(label, this.parent, expression, blockType);
        this.parent.addChild(block);
        return block;
    }

    public Loop loop(String label, Expression expression) {
        Loop loop = new Loop(label, this.parent, expression);
        this.parent.addChild(loop);
        return loop;
    }

    public void branch(LabeledContainer surroundingBlock, Expression expression) {
        Branch branch = new Branch(surroundingBlock, expression);
        this.parent.addChild(branch);
    }

    public void branchIff(LabeledContainer block, WASMValue condition, Expression expression) {
        BranchIff branch = new BranchIff(block, condition, expression);
        this.parent.addChild(branch);
    }

    public void ret(WASMValue value, Expression expression) {
        this.parent.addChild(new ReturnValue(value, expression));
    }

    public void ret(Expression expression) {
        this.parent.addChild(new Return(expression));
    }

    public void nop(Expression expression) {
        this.parent.addChild(new Nop(expression));
    }

    public void drop(WASMValue value, Expression expression) {
        this.parent.addChild(new Drop(value, expression));
    }

    public void unreachable(Expression expression) {
        this.parent.addChild(new Unreachable(expression));
    }

    public void setLocal(Local local, Expression expression) {
        SetLocal setLocal = new SetLocal(local, null, expression);
        this.parent.addChild(setLocal);
    }

    public void setLocal(Local local, WASMValue value, Expression expression) {
        SetLocal setLocal = new SetLocal(local, value, expression);
        this.parent.addChild(setLocal);
    }

    public void setGlobal(Global global, WASMValue value, Expression expression) {
        SetGlobal setGlobal = new SetGlobal(global, value, expression);
        this.parent.addChild(setGlobal);
    }

    public Try Try(String label, Expression expression) {
        Try t = new Try(this.parent, null, label, expression);
        this.parent.addChild(t);
        return t;
    }

    public Try Try(String label, PrimitiveType blockType, Expression expression) {
        Try t = new Try(this.parent, blockType, label, expression);
        this.parent.addChild(t);
        return t;
    }

    public void throwException(WASMEvent exception, List<WASMValue> arguments, Expression expression) {
        ThrowException t = new ThrowException(exception, arguments, expression);
        this.parent.addChild(t);
    }

    public void rethrowException(Expression expression) {
        RethrowException r = new RethrowException(null, expression);
        this.parent.addChild(r);
    }

    public void rethrowException(WASMValue value, Expression expression) {
        RethrowException r = new RethrowException(value, expression);
        this.parent.addChild(r);
    }

    public void branchOnException(LabeledContainer branchContainer, WASMEvent exceptionType, Expression expression) {
        BranchOnException b = new BranchOnException(branchContainer, exceptionType, expression);
        this.parent.addChild(b);
    }

    public class F32 {
        public void store(Alignment alignment, int offset, WASMValue ptr, WASMValue value, Expression expression) {
            F32Store store = new F32Store(alignment, offset, ptr, value, expression);
            Expressions.this.parent.addChild(store);
        }

        public void store(int offset, WASMValue ptr, WASMValue value, Expression expression) {
            F32Store store = new F32Store(offset, ptr, value, expression);
            Expressions.this.parent.addChild(store);
        }
    }

    public class I32 {
        public void store(Alignment alignment, int offset, WASMValue ptr, WASMValue value, Expression expression) {
            I32Store store = new I32Store(alignment, offset, ptr, value, expression);
            Expressions.this.parent.addChild(store);
        }

        public void store(int offset, WASMValue ptr, WASMValue value, Expression expression) {
            I32Store store = new I32Store(offset, ptr, value, expression);
            Expressions.this.parent.addChild(store);
        }

        public void store8(Alignment alignment, int offset, WASMValue ptr, WASMValue value, Expression expression) {
            I32Store8 store = new I32Store8(alignment, offset, ptr, value, expression);
            Expressions.this.parent.addChild(store);
        }

        public void store8(int offset, WASMValue ptr, WASMValue value, Expression expression) {
            I32Store8 store = new I32Store8(offset, ptr, value, expression);
            Expressions.this.parent.addChild(store);
        }

        public void store16(Alignment alignment, int offset, WASMValue ptr, WASMValue value, Expression expression) {
            I32Store16 store = new I32Store16(alignment, offset, ptr, value, expression);
            Expressions.this.parent.addChild(store);
        }

        public void store16(int offset, WASMValue ptr, WASMValue value, Expression expression) {
            I32Store16 store = new I32Store16(offset, ptr, value, expression);
            Expressions.this.parent.addChild(store);
        }
    }
}

