/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.EventIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Exportable;
import de.mirkosertic.bytecoder.backend.wasm.ast.ExportableFunction;
import de.mirkosertic.bytecoder.backend.wasm.ast.Function;
import de.mirkosertic.bytecoder.backend.wasm.ast.FunctionIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Memory;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.ModuleSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExportsSection
extends ModuleSection {
    private final Map<String, Exportable> exports = new HashMap<String, Exportable>();

    ExportsSection(Module aModule) {
        super(aModule);
    }

    public void export(Exportable exportable, String name) {
        this.exports.put(name, exportable);
    }

    public void writeTo(TextWriter textWriter) throws IOException {
        for (Map.Entry<String, Exportable> entry : this.exports.entrySet()) {
            textWriter.opening();
            textWriter.write("export");
            textWriter.space();
            textWriter.writeText(entry.getKey());
            textWriter.space();
            entry.getValue().writeRefTo(textWriter);
            textWriter.closing();
            textWriter.newLine();
        }
    }

    public void writeTo(BinaryWriter binaryWriter, List<Memory> memoryIndex) throws IOException {
        FunctionIndex functionIndex = this.getModule().functionIndex();
        EventIndex eventIndex = this.getModule().eventIndex();
        try (BinaryWriter.SectionWriter exportWriter = binaryWriter.exportsSection();){
            exportWriter.writeUnsignedLeb128(this.exports.size());
            for (Map.Entry<String, Exportable> entry : this.exports.entrySet()) {
                exportWriter.writeUTF8(entry.getKey());
                Exportable value = entry.getValue();
                if (value instanceof ExportableFunction) {
                    exportWriter.writeByte((byte)0);
                    exportWriter.writeUnsignedLeb128(functionIndex.indexOf((Function)((Object)value)));
                    continue;
                }
                if (value instanceof Memory) {
                    exportWriter.writeByte((byte)2);
                    exportWriter.writeUnsignedLeb128(memoryIndex.indexOf(value));
                    continue;
                }
                if (value instanceof WASMEvent) {
                    exportWriter.writeByte((byte)4);
                    exportWriter.writeUnsignedLeb128(eventIndex.indexOf((WASMEvent)value));
                    continue;
                }
                throw new IllegalStateException("Not Implemented yet for " + value);
            }
        }
    }
}

