/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.CompileOptions;
import de.mirkosertic.bytecoder.backend.SourceMapWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class Exporter {
    private final SourceMapWriter sourceMapWriter = new SourceMapWriter();
    private final CompileOptions compileOptions;

    public Exporter(CompileOptions options) {
        this.compileOptions = options;
    }

    public void export(Module module, PrintWriter pw) throws IOException {
        try (TextWriter writer = new TextWriter(pw);){
            module.writeTo(writer, this.compileOptions.isDebugOutput());
        }
        pw.flush();
    }

    public void export(Module module, OutputStream binaryOutput, Writer sourcemapOutput) throws IOException {
        SourceMapWriter sourceMapWriter = new SourceMapWriter();
        try (BinaryWriter binaryWriter = new BinaryWriter(sourceMapWriter);){
            module.writeTo(binaryWriter, this.compileOptions.isDebugOutput());
            byte[] theData = binaryWriter.toByteArray();
            binaryOutput.write(theData);
        }
        sourcemapOutput.write(sourceMapWriter.toSourceMap(this.compileOptions.getFilenamePrefix() + ".wasm"));
    }
}

