/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Container;
import de.mirkosertic.bytecoder.backend.wasm.ast.EventIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Exportable;
import de.mirkosertic.bytecoder.backend.wasm.ast.Function;
import de.mirkosertic.bytecoder.backend.wasm.ast.FunctionIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.GlobalsIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Local;
import de.mirkosertic.bytecoder.backend.wasm.ast.LocalIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.Param;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TablesSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TypeIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import java.io.IOException;
import java.util.List;

public class ExportableFunction
extends Function
implements Exportable {
    private final LocalIndex localIndex;

    ExportableFunction(Module aModule, WASMType functionType, String label, List<Param> params, PrimitiveType result) {
        super(aModule, functionType, label, params, result);
        this.localIndex = new LocalIndex(params);
    }

    ExportableFunction(Module aModule, WASMType functionType, String label, List<Param> params) {
        super(aModule, functionType, label, params);
        this.localIndex = new LocalIndex(params);
    }

    ExportableFunction(Module aModule, WASMType functionType, String label, PrimitiveType result) {
        super(aModule, functionType, label, result);
        this.localIndex = new LocalIndex();
    }

    public void exportAs(String functionName) {
        this.getModule().getExports().export(this, functionName);
    }

    public Local localByLabel(String label) {
        Local local = this.localIndex.localByLabel(label);
        if (local != null) {
            return local;
        }
        throw new IllegalArgumentException("No such local : " + label);
    }

    public LocalIndex localIndex() {
        return this.localIndex;
    }

    public Local newLocal(String label, PrimitiveType type) {
        if (this.localIndex.localByLabel(label) != null) {
            throw new IllegalStateException("Local " + label + " already defined!");
        }
        Local local = new Local(label, type);
        this.localIndex.add(local);
        return local;
    }

    @Override
    public void writeTo(TextWriter textWriter, Module aModule) throws IOException {
        textWriter.opening();
        textWriter.write("func");
        textWriter.space();
        textWriter.writeLabel(this.getLabel());
        textWriter.space();
        this.getFunctionType().writeRefTo(textWriter);
        if (this.getParams() != null) {
            for (Param param : this.getParams()) {
                textWriter.space();
                param.writeTo(textWriter);
            }
        }
        if (this.getResultType() != null) {
            textWriter.space();
            textWriter.opening();
            textWriter.write("result");
            textWriter.space();
            this.getResultType().writeTo(textWriter);
            textWriter.closing();
        }
        textWriter.newLine();
        for (Local local : this.localIndex.localsExcludingParams()) {
            local.writeTo(textWriter);
            textWriter.newLine();
        }
        DefaultExportContext context = new DefaultExportContext(this, this.getModule().functionIndex());
        for (WASMExpression expression : this.getChildren()) {
            expression.writeTo(textWriter, (WASMValue.ExportContext)context);
        }
        textWriter.closing();
    }

    @Override
    public void writeRefTo(TextWriter textWriter) {
        textWriter.opening();
        textWriter.write("func");
        textWriter.space();
        textWriter.writeLabel(this.getLabel());
        textWriter.closing();
    }

    public void writeCodeTo(BinaryWriter.Writer sectionWriter, FunctionIndex functionIndex) throws IOException {
        try (BinaryWriter.BlockWriter codeWriter = sectionWriter.blockWriter();){
            List<Local> locals = this.localIndex.localsExcludingParams();
            codeWriter.writeUnsignedLeb128(locals.size());
            for (Local local : locals) {
                codeWriter.writeUnsignedLeb128(1);
                local.getType().writeTo(codeWriter);
            }
            DefaultExportContext context = new DefaultExportContext(this, functionIndex);
            for (WASMExpression expression : this.getChildren()) {
                expression.writeTo(codeWriter, (WASMValue.ExportContext)context);
            }
            codeWriter.writeByte((byte)11);
        }
    }

    @Override
    public ExportableFunction toTable() {
        return (ExportableFunction)super.toTable();
    }

    private class DefaultExportContext
    implements WASMValue.ExportContext {
        private final Container owningContainer;
        private final FunctionIndex functionIndex;

        DefaultExportContext(Container owningContainer, FunctionIndex functionIndex) {
            this.owningContainer = owningContainer;
            this.functionIndex = functionIndex;
        }

        @Override
        public Container owningContainer() {
            return this.owningContainer;
        }

        @Override
        public FunctionIndex functionIndex() {
            return this.functionIndex;
        }

        @Override
        public GlobalsIndex globalsIndex() {
            return ExportableFunction.this.getModule().getGlobals().globalsIndex();
        }

        @Override
        public LocalIndex localIndex() {
            return ExportableFunction.this.localIndex;
        }

        @Override
        public WASMValue.ExportContext subWith(Container container) {
            return new DefaultExportContext(container, this.functionIndex);
        }

        @Override
        public TypeIndex typeIndex() {
            return ExportableFunction.this.getModule().getTypes().typesIndex();
        }

        @Override
        public TablesSection.AnyFuncTable anyFuncTable() {
            return ExportableFunction.this.getModule().getTables().funcTable();
        }

        @Override
        public EventIndex eventIndex() {
            return ExportableFunction.this.getModule().eventIndex();
        }
    }
}

