/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.EventIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.ModuleSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMEvent;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import java.io.IOException;
import java.util.List;

public class EventSection
extends ModuleSection {
    private final EventIndex eventIndex = new EventIndex();

    public EventSection(Module module) {
        super(module);
    }

    public EventIndex eventIndex() {
        return this.eventIndex;
    }

    public WASMEvent newException(String label, List<PrimitiveType> arguments) {
        WASMType type = this.getModule().getTypes().typeFor(arguments);
        WASMEvent e = new WASMEvent(this.getModule().getTypes(), label, type);
        this.eventIndex.add(e);
        return e;
    }

    public void writeCodeTo(BinaryWriter writer) throws IOException {
        if (!this.eventIndex.isEmpty()) {
            try (BinaryWriter.SectionWriter sectionWriter = writer.eventSection();){
                sectionWriter.writeUTF8("event");
                sectionWriter.writeUnsignedLeb128(this.eventIndex.size());
                for (int i = 0; i < this.eventIndex.size(); ++i) {
                    WASMEvent event = this.eventIndex.get(i);
                    event.writeTo(sectionWriter);
                }
            }
        }
    }

    public void writeCodeTo(TextWriter writer) throws IOException {
        for (int i = 0; i < this.eventIndex.size(); ++i) {
            WASMEvent event = this.eventIndex.get(i);
            event.writeTo(writer);
        }
    }
}

