/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Function;
import de.mirkosertic.bytecoder.backend.wasm.ast.FunctionIndex;
import de.mirkosertic.bytecoder.backend.wasm.ast.Module;
import de.mirkosertic.bytecoder.backend.wasm.ast.ModuleSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.TablesSection;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import java.io.IOException;
import java.util.List;

public class ElementSection
extends ModuleSection {
    ElementSection(Module aModule) {
        super(aModule);
    }

    public void writeTo(TextWriter textWriter) {
        if (this.getModule().getTables().hasFuncTable()) {
            TablesSection.AnyFuncTable any = this.getModule().getTables().funcTable();
            List<Function> functions = any.functions();
            for (int i = 0; i < functions.size(); ++i) {
                textWriter.opening();
                textWriter.write("elem");
                textWriter.space();
                textWriter.opening();
                textWriter.write("i32.const");
                textWriter.space();
                textWriter.writeInteger(i);
                textWriter.closing();
                textWriter.space();
                textWriter.writeLabel(functions.get(i).getLabel());
                textWriter.closing();
                textWriter.newLine();
            }
        }
    }

    public void writeTo(BinaryWriter binaryWriter, FunctionIndex functionIndex) throws IOException {
        try (BinaryWriter.SectionWriter writer = binaryWriter.elementsSection();){
            if (this.getModule().getTables().hasFuncTable()) {
                TablesSection.AnyFuncTable any = this.getModule().getTables().funcTable();
                List<Function> functions = any.functions();
                writer.writeUnsignedLeb128(functions.size());
                for (int i = 0; i < functions.size(); ++i) {
                    writer.writeUnsignedLeb128(any.index());
                    writer.writeByte((byte)65);
                    writer.writeSignedLeb128(i);
                    writer.writeByte((byte)11);
                    writer.writeUnsignedLeb128(1);
                    writer.writeUnsignedLeb128(functionIndex.indexOf(functions.get(i)));
                }
            } else {
                writer.writeUnsignedLeb128(0);
            }
        }
    }
}

