/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.Expressions;
import de.mirkosertic.bytecoder.backend.wasm.ast.LabeledContainer;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import java.util.ArrayList;
import java.util.List;

public abstract class Container {
    public final Expressions flow;
    private final Container parent;
    private final List<WASMExpression> children;

    protected Container(Container parent) {
        this.parent = parent;
        this.children = new ArrayList<WASMExpression>();
        this.flow = new Expressions(this);
    }

    protected Container() {
        this.parent = null;
        this.children = new ArrayList<WASMExpression>();
        this.flow = new Expressions(this);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<WASMExpression> getChildren() {
        return this.children;
    }

    public void addChild(WASMExpression e) {
        this.children.add(e);
    }

    public int relativeDepthTo(LabeledContainer outerBlock) {
        return this.relativeDepthTo(outerBlock, 0);
    }

    public int relativeDepthTo(LabeledContainer outerBlock, int offset) {
        if (this == outerBlock) {
            return offset;
        }
        if (this.parent != null) {
            return this.parent.relativeDepthTo(outerBlock, offset + 1);
        }
        throw new IllegalArgumentException("Cannot find block " + outerBlock.getLabel());
    }

    public LabeledContainer findByLabelInHierarchy(String aLabel) {
        if (this.parent != null) {
            return this.parent.findByLabelInHierarchy(aLabel);
        }
        throw new IllegalArgumentException("No such parent container : " + aLabel);
    }

    public Container end() {
        return this.parent;
    }
}

