/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.Alignment;
import de.mirkosertic.bytecoder.backend.wasm.ast.Call;
import de.mirkosertic.bytecoder.backend.wasm.ast.CallIndirect;
import de.mirkosertic.bytecoder.backend.wasm.ast.Callable;
import de.mirkosertic.bytecoder.backend.wasm.ast.CurrentMemory;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Abs;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Add;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Ceil;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Const;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32ConvertSI32;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32ConvertUI32;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32CopySign;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Div;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Eq;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Floor;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Ge;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Gt;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Le;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Load;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Lt;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Max;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Min;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Mul;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Ne;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Nearest;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Neg;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Sqrt;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Sub;
import de.mirkosertic.bytecoder.backend.wasm.ast.F32Trunc;
import de.mirkosertic.bytecoder.backend.wasm.ast.GetGlobal;
import de.mirkosertic.bytecoder.backend.wasm.ast.GetLocal;
import de.mirkosertic.bytecoder.backend.wasm.ast.Global;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Add;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32And;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Clz;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Const;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Ctz;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32DivS;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32DivU;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Eq;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Eqz;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32GeS;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32GeU;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32GtS;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32GtU;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32LeS;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32LeU;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Load;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Load16S;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Load16U;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Load8S;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Load8U;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32LtS;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32LtU;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Mul;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Ne;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Or;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Popcount;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32ReinterpretF32;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32RemS;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32RemU;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Rotl;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Rotr;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Shl;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32ShrS;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32ShrU;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Sub;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32TruncSF32;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32TruncUF32;
import de.mirkosertic.bytecoder.backend.wasm.ast.I32Xor;
import de.mirkosertic.bytecoder.backend.wasm.ast.Local;
import de.mirkosertic.bytecoder.backend.wasm.ast.Param;
import de.mirkosertic.bytecoder.backend.wasm.ast.PrimitiveType;
import de.mirkosertic.bytecoder.backend.wasm.ast.Select;
import de.mirkosertic.bytecoder.backend.wasm.ast.TeeLocal;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.backend.wasm.ast.WeakFunctionReferenceCallable;
import de.mirkosertic.bytecoder.backend.wasm.ast.WeakFunctionTableReference;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.util.List;

public class ConstExpressions {
    public static Param param(String label, PrimitiveType type) {
        return new Param(label, type);
    }

    public static Call call(Callable function, List<WASMValue> arguments, Expression expression) {
        return new Call(function, arguments, expression);
    }

    public static CallIndirect call(WASMType type, List<WASMValue> arguments, WASMValue functionIndex, Expression expression) {
        return new CallIndirect(type, arguments, functionIndex, expression);
    }

    public static GetLocal getLocal(Local local, Expression expression) {
        return new GetLocal(local, expression);
    }

    public static TeeLocal teeLocal(Local local, WASMValue value, Expression expression) {
        return new TeeLocal(local, value, expression);
    }

    public static TeeLocal teeLocal(Local local, Expression expression) {
        return new TeeLocal(local, null, expression);
    }

    public static GetGlobal getGlobal(Global global, Expression expression) {
        return new GetGlobal(global, expression);
    }

    public static CurrentMemory currentMemory(Expression expression) {
        return new CurrentMemory(expression);
    }

    public static Select select(WASMValue leftValue, WASMValue rightValue, WASMValue condition, Expression expression) {
        return new Select(leftValue, rightValue, condition, expression);
    }

    public static WeakFunctionTableReference weakFunctionTableReference(String aFunctionName, Expression expression) {
        return new WeakFunctionTableReference(aFunctionName, expression);
    }

    public static WeakFunctionReferenceCallable weakFunctionReference(String aFunctionName, Expression expression) {
        return new WeakFunctionReferenceCallable(aFunctionName, expression);
    }

    public static class f32 {
        public static F32Const c(float aValue, Expression expression) {
            return new F32Const(aValue, expression);
        }

        public static F32Eq eq(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Eq(leftValue, rightValue, expression);
        }

        public static F32Ne ne(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Ne(leftValue, rightValue, expression);
        }

        public static F32Ge ge(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Ge(leftValue, rightValue, expression);
        }

        public static F32Gt gt(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Gt(leftValue, rightValue, expression);
        }

        public static F32Le le(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Le(leftValue, rightValue, expression);
        }

        public static F32Lt lt(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Lt(leftValue, rightValue, expression);
        }

        public static F32Abs abs(WASMValue value, Expression expression) {
            return new F32Abs(value, expression);
        }

        public static F32Add add(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Add(leftValue, rightValue, expression);
        }

        public static F32Sub sub(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Sub(leftValue, rightValue, expression);
        }

        public static F32Max max(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Max(leftValue, rightValue, expression);
        }

        public static F32Min min(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Min(leftValue, rightValue, expression);
        }

        public static F32Mul mul(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Mul(leftValue, rightValue, expression);
        }

        public static F32Div div(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32Div(leftValue, rightValue, expression);
        }

        public static F32CopySign copysign(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new F32CopySign(leftValue, rightValue, expression);
        }

        public static F32Ceil ceil(WASMValue value, Expression expression) {
            return new F32Ceil(value, expression);
        }

        public static F32Nearest nearest(WASMValue value, Expression expression) {
            return new F32Nearest(value, expression);
        }

        public static F32Neg neg(WASMValue value, Expression expression) {
            return new F32Neg(value, expression);
        }

        public static F32Sqrt sqrt(WASMValue value, Expression expression) {
            return new F32Sqrt(value, expression);
        }

        public static F32Trunc trunc(WASMValue value, Expression expression) {
            return new F32Trunc(value, expression);
        }

        public static F32Floor floor(WASMValue value, Expression expression) {
            return new F32Floor(value, expression);
        }

        public static F32ConvertSI32 convert_sI32(WASMValue value, Expression expression) {
            return new F32ConvertSI32(value, expression);
        }

        public static F32ConvertUI32 convert_uI32(WASMValue value, Expression expression) {
            return new F32ConvertUI32(value, expression);
        }

        public static F32Load load(Alignment alignment, int offset, WASMValue ptr, Expression expression) {
            return new F32Load(alignment, offset, ptr, expression);
        }

        public static F32Load load(int offset, WASMValue ptr, Expression expression) {
            return new F32Load(offset, ptr, expression);
        }
    }

    public static class i32 {
        public static I32Const c(int aValue, Expression expression) {
            return new I32Const(aValue, expression);
        }

        public static I32Eq eq(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32Eq(leftValue, rightValue, expression);
        }

        public static I32Ne ne(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32Ne(leftValue, rightValue, expression);
        }

        public static I32GeS ge_s(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32GeS(leftValue, rightValue, expression);
        }

        public static I32GeU ge_u(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32GeU(leftValue, rightValue, expression);
        }

        public static I32GtS gt_s(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32GtS(leftValue, rightValue, expression);
        }

        public static I32GtU gt_u(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32GtU(leftValue, rightValue, expression);
        }

        public static I32LeS le_s(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32LeS(leftValue, rightValue, expression);
        }

        public static I32LeU le_u(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32LeU(leftValue, rightValue, expression);
        }

        public static I32LtS lt_s(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32LtS(leftValue, rightValue, expression);
        }

        public static I32LtU lt_u(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32LtU(leftValue, rightValue, expression);
        }

        public static I32Eqz eqz(WASMValue value, Expression expression) {
            return new I32Eqz(value, expression);
        }

        public static I32Popcount popcount(WASMValue value, Expression expression) {
            return new I32Popcount(value, expression);
        }

        public static I32ReinterpretF32 reinterpretF32(WASMValue value, Expression expression) {
            return new I32ReinterpretF32(value, expression);
        }

        public static I32Add add(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32Add(leftValue, rightValue, expression);
        }

        public static I32And and(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32And(leftValue, rightValue, expression);
        }

        public static I32Or or(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32Or(leftValue, rightValue, expression);
        }

        public static I32Sub sub(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32Sub(leftValue, rightValue, expression);
        }

        public static I32Mul mul(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32Mul(leftValue, rightValue, expression);
        }

        public static I32DivS div_s(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32DivS(leftValue, rightValue, expression);
        }

        public static I32DivU div_u(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32DivU(leftValue, rightValue, expression);
        }

        public static I32RemS rem_s(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32RemS(leftValue, rightValue, expression);
        }

        public static I32RemU rem_u(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32RemU(leftValue, rightValue, expression);
        }

        public static I32Rotl rotl(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32Rotl(leftValue, rightValue, expression);
        }

        public static I32Rotr rotr(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32Rotr(leftValue, rightValue, expression);
        }

        public static I32Shl shl(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32Shl(leftValue, rightValue, expression);
        }

        public static I32ShrS shr_s(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32ShrS(leftValue, rightValue, expression);
        }

        public static I32ShrU shr_u(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32ShrU(leftValue, rightValue, expression);
        }

        public static I32Xor xor(WASMValue leftValue, WASMValue rightValue, Expression expression) {
            return new I32Xor(leftValue, rightValue, expression);
        }

        public static I32Clz clz(WASMValue value, Expression expression) {
            return new I32Clz(value, expression);
        }

        public static I32Ctz ctz(WASMValue value, Expression expression) {
            return new I32Ctz(value, expression);
        }

        public static I32TruncSF32 trunc_sF32(WASMValue value, Expression expression) {
            return new I32TruncSF32(value, expression);
        }

        public static I32TruncUF32 trunc_uF32(WASMValue value, Expression expression) {
            return new I32TruncUF32(value, expression);
        }

        public static I32Load load(Alignment alignment, int offset, WASMValue ptr, Expression expression) {
            return new I32Load(alignment, offset, ptr, expression);
        }

        public static I32Load load(int offset, WASMValue ptr, Expression expression) {
            return new I32Load(offset, ptr, expression);
        }

        public static I32Load8S load8_s(Alignment alignment, int offset, WASMValue ptr, Expression expression) {
            return new I32Load8S(alignment, offset, ptr, expression);
        }

        public static I32Load8S load8_s(int offset, WASMValue ptr, Expression expression) {
            return new I32Load8S(offset, ptr, expression);
        }

        public static I32Load16S load16_s(Alignment alignment, int offset, WASMValue ptr, Expression expression) {
            return new I32Load16S(alignment, offset, ptr, expression);
        }

        public static I32Load16S load16_s(int offset, WASMValue ptr, Expression expression) {
            return new I32Load16S(offset, ptr, expression);
        }

        public static I32Load8U load8_u(Alignment alignment, int offset, WASMValue ptr, Expression expression) {
            return new I32Load8U(alignment, offset, ptr, expression);
        }

        public static I32Load8U load8_u(int offset, WASMValue ptr, Expression expression) {
            return new I32Load8U(offset, ptr, expression);
        }

        public static I32Load16U load16_u(Alignment alignment, int offset, WASMValue ptr, Expression expression) {
            return new I32Load16U(alignment, offset, ptr, expression);
        }

        public static I32Load16U load16_u(int offset, WASMValue ptr, Expression expression) {
            return new I32Load16U(offset, ptr, expression);
        }
    }
}

