/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMType;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;
import java.util.List;

public class CallIndirect
implements WASMExpression {
    private final WASMType functionType;
    private final List<WASMValue> arguments;
    private final WASMValue functionIndex;
    private final Expression expression;

    CallIndirect(WASMType functionType, List<WASMValue> arguments, WASMValue functionIndex, Expression expression) {
        this.functionType = functionType;
        this.arguments = arguments;
        this.functionIndex = functionIndex;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        textWriter.opening();
        textWriter.write("call_indirect");
        textWriter.space();
        this.functionType.writeRefTo(textWriter);
        for (WASMValue argument : this.arguments) {
            textWriter.space();
            argument.writeTo(textWriter, context);
        }
        textWriter.space();
        this.functionIndex.writeTo(textWriter, context);
        textWriter.closing();
        if (this.functionType.isVoid()) {
            textWriter.newLine();
        }
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        for (WASMValue argument : this.arguments) {
            argument.writeTo(codeWriter, context);
        }
        this.functionIndex.writeTo(codeWriter, context);
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)17);
        codeWriter.writeUnsignedLeb128(context.typeIndex().indexOf(this.functionType));
        codeWriter.writeByte((byte)0);
    }
}

