/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.Callable;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;
import java.util.List;

public class Call
implements WASMExpression {
    private final Callable function;
    private final List<WASMValue> arguments;
    private final Expression expression;

    Call(Callable function, List<WASMValue> arguments, Expression expression) {
        this.function = function;
        this.arguments = arguments;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) throws IOException {
        textWriter.opening();
        textWriter.write("call");
        textWriter.space();
        textWriter.writeLabel(this.function.getLabel());
        for (WASMValue argument : this.arguments) {
            textWriter.space();
            argument.writeTo(textWriter, context);
        }
        textWriter.closing();
        if (this.function.resolveResultType(context) == null) {
            textWriter.newLine();
        }
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        for (WASMValue argument : this.arguments) {
            argument.writeTo(codeWriter, context);
        }
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)16);
        codeWriter.writeUnsignedLeb128(this.function.resolveIndex(context));
    }
}

