/*
 * Decompiled with CFR 0.152.
 */
package de.mirkosertic.bytecoder.backend.wasm.ast;

import de.mirkosertic.bytecoder.backend.wasm.ast.BinaryWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.LabeledContainer;
import de.mirkosertic.bytecoder.backend.wasm.ast.TextWriter;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMEvent;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMExpression;
import de.mirkosertic.bytecoder.backend.wasm.ast.WASMValue;
import de.mirkosertic.bytecoder.ssa.Expression;
import java.io.IOException;

public class BranchOnException
implements WASMExpression {
    private final LabeledContainer targetContainer;
    private final WASMEvent exceptionType;
    private final Expression expression;

    BranchOnException(LabeledContainer targetContainer, WASMEvent exceptionType, Expression expression) {
        this.targetContainer = targetContainer;
        this.exceptionType = exceptionType;
        this.expression = expression;
    }

    @Override
    public void writeTo(TextWriter textWriter, WASMValue.ExportContext context) {
        textWriter.opening();
        textWriter.write("br_on_exn");
        textWriter.space();
        textWriter.writeLabel(this.targetContainer.getLabel());
        textWriter.space();
        textWriter.writeLabel(this.exceptionType.getLabel());
        textWriter.closing();
        textWriter.newLine();
    }

    @Override
    public void writeTo(BinaryWriter.Writer codeWriter, WASMValue.ExportContext context) throws IOException {
        int relativeDepth = context.owningContainer().relativeDepthTo(this.targetContainer);
        codeWriter.registerDebugInformationFor(this.expression);
        codeWriter.writeByte((byte)10);
        codeWriter.writeUnsignedLeb128(relativeDepth);
        codeWriter.writeUnsignedLeb128(context.eventIndex().indexOf(this.exceptionType));
    }
}

